@extends('layout.default', [
    'bodyClass' => 'pace-top',
    'appHeaderHide' => true,
    'appSidebarHide' => true,
    'appContentHide' => true,
    'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Confirm Password')

@section('content')
    <!-- BEGIN confirm-password -->
    <div class="confirm-password">
        <!-- BEGIN confirm-password-content -->
        <div class="confirm-password-content">
            <div class="card">
                <div class="card-body p-4">
                    <h1 class="text-center mb-3">Confirm Password</h1>
                    
                    <div class="text-inverse text-opacity-50 text-center mb-4">
                        This is a secure area of the application. Please confirm your password before continuing.
                    </div>

                    <form method="POST" action="{{ route('password.confirm') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">Password <span class="text-danger">*</span></label>
                            <input type="password" name="password" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('password') is-invalid @enderror" required autocomplete="current-password">
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3">
                            Confirm Password
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <!-- END confirm-password-content -->
    </div>
    <!-- END confirm-password -->
@endsection
