@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appContentHide' => true,
	'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Forgot Password')

@section('content')
  <!-- BEGIN forgot-password -->
	<div class="forgot-password">
		<!-- BEGIN forgot-password-content -->
		<div class="forgot-password-content">
			<form action="{{ route('password.email') }}" method="POST">
				@csrf
				<h1 class="text-center">Forgot Password</h1>
				<div class="text-inverse text-opacity-50 text-center mb-4">
					Enter your email address and we'll send you an email with instructions to reset your password.
				</div>

				@if (session('status'))
					<div class="alert alert-success" role="alert">
						{{ session('status') }}
					</div>
				@endif

				<div class="mb-3">
					<label class="form-label">Email Address <span class="text-danger">*</span></label>
					<input type="email" name="email" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('email') is-invalid @enderror" value="{{ old('email') }}" required autofocus>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<button type="submit" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3">Reset Password</button>
				<div class="text-center text-inverse text-opacity-50">
					<a href="{{ route('login') }}" class="text-decoration-none">Back to Login</a>
				</div>
			</form>
		</div>
		<!-- END forgot-password-content -->
	</div>
	<!-- END forgot-password -->
@endsection
