@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appContentHide' => true,
	'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Login')

@section('content')
  <!-- BEGIN login -->
	<div class="login">
		<!-- BEGIN login-content -->
		<div class="login-content">
			<form action="{{ route('login') }}" method="POST">
				@csrf
				<h1 class="text-center">Sign In</h1>
				<div class="text-inverse text-opacity-50 text-center mb-4">
					For your protection, please verify your identity.
				</div>
				<div class="mb-3">
					<label class="form-label">Email Address <span class="text-danger">*</span></label>
					<input type="email" name="email" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('email') is-invalid @enderror" value="{{ old('email') }}" required autofocus>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<div class="mb-3">
					<div class="d-flex">
						<label class="form-label">Password <span class="text-danger">*</span></label>
						<a href="{{ route('password.request') }}" class="ms-auto text-inverse text-decoration-none text-opacity-50">Forgot password?</a>
					</div>
					<input type="password" name="password" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('password') is-invalid @enderror" required>
					@error('password')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>
				<div class="mb-3">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" name="remember" id="remember">
						<label class="form-check-label" for="remember">Remember me</label>
					</div>
				</div>
				<button type="submit" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3">Sign In</button>
				<div class="text-center text-inverse text-opacity-50">
					Don't have an account yet? <a href="{{ route('register') }}">Sign up</a>.
				</div>
			</form>
		</div>
		<!-- END login-content -->
	</div>
	<!-- END login -->
@endsection

