@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appContentHide' => true,
	'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Register')

@section('content')
  <!-- BEGIN register -->
	<div class="register">
		<!-- BEGIN register-content -->
		<div class="register-content">
			<form action="{{ route('register') }}" method="POST">
				@csrf
				<h1 class="text-center">Sign Up</h1>
				<p class="text-inverse text-opacity-50 text-center">One Admin ID is all you need to access all the Admin services.</p>

				<div class="mb-3">
					<label class="form-label">Name <span class="text-danger">*</span></label>
					<input type="text" name="name" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('name') is-invalid @enderror" value="{{ old('name') }}" required autofocus>
					@error('name')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Title</label>
					<input type="text" name="title" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('title') is-invalid @enderror" value="{{ old('title') }}">
					@error('title')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Email Address <span class="text-danger">*</span></label>
					<input type="email" name="email" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('email') is-invalid @enderror" value="{{ old('email') }}" required>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Mobile</label>
					<input type="text" name="mobile" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('mobile') is-invalid @enderror" value="{{ old('mobile') }}">
					@error('mobile')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Company Name</label>
					<input type="text" name="company_name" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('company_name') is-invalid @enderror" value="{{ old('company_name') }}">
					@error('company_name')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Password <span class="text-danger">*</span></label>
					<input type="password" name="password" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('password') is-invalid @enderror" required>
					@error('password')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Confirm Password <span class="text-danger">*</span></label>
					<input type="password" name="password_confirmation" class="form-control form-control-lg bg-inverse bg-opacity-5" required>
				</div>

				<div class="mb-3">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" name="terms" id="terms" required @if(old('terms')) checked @endif>
						<label class="form-check-label" for="terms">
							I agree to the Terms and Conditions
						</label>
						@error('terms')
							<div class="invalid-feedback d-block">{{ $message }}</div>
						@enderror
					</div>
				</div>

				<button type="submit" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3">Sign Up</button>

				<div class="text-center text-inverse text-opacity-50">
					Already have an Admin ID? <a href="{{ route('login') }}">Sign In</a>
				</div>
			</form>
		</div>
		<!-- END register-content -->
	</div>
	<!-- END register -->
@endsection
