@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appContentHide' => true,
	'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Reset Password')

@section('content')
  <!-- BEGIN reset-password -->
	<div class="reset-password">
		<!-- BEGIN reset-password-content -->
		<div class="reset-password-content">
			<form action="{{ route('password.store') }}" method="POST">
				@csrf
				<!-- Password Reset Token -->
				<input type="hidden" name="token" value="{{ $request->route('token') }}">

				<h1 class="text-center">Reset Password</h1>
				<div class="text-inverse text-opacity-50 text-center mb-4">
					Enter your new password below
				</div>

				<div class="mb-3">
					<label class="form-label">Email Address <span class="text-danger">*</span></label>
					<input type="email" name="email" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('email') is-invalid @enderror" value="{{ old('email', $request->email) }}" required autofocus>
					@error('email')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">New Password <span class="text-danger">*</span></label>
					<input type="password" name="password" class="form-control form-control-lg bg-inverse bg-opacity-5 @error('password') is-invalid @enderror" required>
					@error('password')
						<div class="invalid-feedback">{{ $message }}</div>
					@enderror
				</div>

				<div class="mb-3">
					<label class="form-label">Confirm Password <span class="text-danger">*</span></label>
					<input type="password" name="password_confirmation" class="form-control form-control-lg bg-inverse bg-opacity-5" required>
				</div>

				<button type="submit" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3">Reset Password</button>
				<div class="text-center text-inverse text-opacity-50">
					<a href="{{ route('login') }}" class="text-decoration-none">Back to Login</a>
				</div>
			</form>
		</div>
		<!-- END reset-password-content -->
	</div>
	<!-- END reset-password -->
@endsection
