@extends('layout.default', [
    'bodyClass' => 'pace-top',
    'appHeaderHide' => true,
    'appSidebarHide' => true,
    'appContentHide' => true,
    'appClass' => 'app-full-height app-without-header p-0'
])

@section('title', 'Verify Email')

@section('content')
    <!-- BEGIN verify-email -->
    <div class="verify-email">
        <!-- BEGIN verify-email-content -->
        <div class="verify-email-content">
            <div class="card">
                <div class="card-body p-4">
                    <h1 class="text-center mb-3">Email Verification</h1>

                    <div class="text-inverse text-opacity-50 text-center mb-4">
                        Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.
                    </div>

                    @if (session('status') == 'verification-link-sent')
                        <div class="alert alert-success" role="alert">
                            A new verification link has been sent to the email address you provided during registration.
                        </div>
                    @endif

                    <div class="d-flex justify-content-between mt-4">
                        <form method="POST" action="{{ route('verification.send') }}">
                            @csrf
                            <button type="submit" class="btn btn-outline-theme">
                                Resend Verification Email
                            </button>
                        </form>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="btn btn-link text-inverse text-opacity-50 text-decoration-none">
                                Log Out
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- END verify-email-content -->
    </div>
    <!-- END verify-email -->
@endsection
