@extends('layout.default', [
  'appClass' => 'app-content-full-height',
  'appContentClass' => 'p-3'
])

@section('title', 'Compose')

@push('css')
  <link href="/assets/plugins/summernote/dist/summernote-lite.css" rel="stylesheet">
@endpush

@push('js')
  <script src="/assets/plugins/jquery-migrate/dist/jquery-migrate.min.js"></script>
  <script src="/assets/plugins/summernote/dist/summernote-lite.min.js"></script>
@endpush

@section('content')
<div class="card h-100">
  <div class="mailbox">

    <div class="mailbox-toolbar d-flex align-items-center flex-wrap gap-2">
      <div class="mailbox-toolbar-item">
        <span class="mailbox-toolbar-text">New Message</span>
      </div>
      <div class="ms-auto mailbox-toolbar-item">
        <a href="{{ route('email.inbox') }}" class="mailbox-toolbar-link"><i class="fa fa-times fa-fw"></i> Cancel</a>
      </div>
    </div>

    <div class="mailbox-body">
      <div class="mailbox-content">
        <div data-scrollbar="true" data-height="100%">
          <div class="mailbox-form">

            {{-- Alerts --}}
            @if (session('ok'))
              <div class="alert alert-success">{{ session('ok') }}</div>
            @endif
            @if ($errors->any())
              <div class="alert alert-danger">
                <ul class="mb-0">
                  @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                  @endforeach
                </ul>
              </div>
            @endif

            <form action="{{ route('email.send') }}" method="POST" enctype="multipart/form-data" name="email_form">
              @csrf

              <div class="mailbox-form-header">
                <div class="row mb-2">
                  <label class="col-form-label w-100px px-2 fw-500 text-lg-end">To:</label>
                  <div class="col-lg">
                    <input type="text" name="to" class="form-control"
                           value="{{ old('to', $init['to'] ?? '') }}"
                           placeholder="e.g. someone@example.com, other@company.com" required>
                  </div>
                </div>

                <div class="row mb-2">
                  <label class="col-form-label w-100px px-2 fw-500 text-lg-end">Cc:</label>
                  <div class="col-lg">
                    <input type="text" name="cc" class="form-control"
                           value="{{ old('cc', $init['cc'] ?? '') }}"
                           placeholder="optional">
                  </div>
                </div>

                <div class="row mb-2">
                  <label class="col-form-label w-100px px-2 fw-500 text-lg-end">Bcc:</label>
                  <div class="col-lg">
                    <input type="text" name="bcc" class="form-control"
                           value="{{ old('bcc', $init['bcc'] ?? '') }}"
                           placeholder="optional">
                  </div>
                </div>

                <div class="row mb-2">
                  <label class="col-form-label w-100px px-2 fw-500 text-lg-end">Subject:</label>
                  <div class="col-lg">
                    <input type="text" name="subject" class="form-control"
                           value="{{ old('subject', $init['subject'] ?? '') }}"
                           placeholder="Email subject" required>
                  </div>
                </div>

                <div class="row mb-2">
                  <label class="col-form-label w-100px px-2 fw-500 text-lg-end">Attachments:</label>
                  <div class="col-lg">
                    <input type="file" name="attachments[]" class="form-control" multiple>
                    <small class="text-muted">Optional. Max 10MB per file.</small>
                  </div>
                </div>
              </div>

              <textarea name="body" class="summernote form-control" title="Contents">
                {{ old('body', $init['body'] ?? '') }}
              </textarea>

              <div class="text-end mt-3">
                <button type="submit" class="btn btn-success">
                  <i class="fa fa-paper-plane me-1"></i> Send
                </button>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>

  </div>

  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>

@push('scripts')
<script>
  (function(){
    var $ = window.jQuery;
    if (window.jQuery && $.fn.summernote) {
      $('.summernote').summernote({
        placeholder: 'Write your message here…',
        height: 260
      });
    }
  })();
</script>
@endpush
@endsection
