{{-- resources/views/email/connect.blade.php --}}
@extends('layout.default', [
	'appClass' => 'app-content-full-height',
	'appContentClass' => 'p-0'
])

@section('title', 'Connect Mailbox')

@section('content')
@php
    $user = Auth::user();
    $connected = filled($user->imap_username) && filled($user->imap_password_encrypted);
    $masked = null;
    if ($user->imap_username) {
        [$local, $domain] = array_pad(explode('@', $user->imap_username, 2), 2, '');
        $masked = (strlen($local) ? substr($local,0,1).'****' : '****') . '@' . $domain;
    }
@endphp

<div class="container py-4">

    {{-- Alerts --}}
    @if(session('ok'))
        <div class="alert alert-success">{{ session('ok') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <div class="fw-bold mb-1">Please fix the following:</div>
            <ul class="mb-0">
                @foreach ($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row g-4">
        {{-- Status card --}}
        <div class="col-12 col-lg-5">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="m-0">Mailbox Status</h5>
                    <span class="badge {{ $connected ? 'bg-success' : 'bg-secondary' }}">
                        {{ $connected ? 'Connected' : 'Not Connected' }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="mb-2 text-muted">Current user: <strong>{{ $user->name ?? $user->email }}</strong></div>
                    <div class="mb-3">
                        <div class="text-muted">IMAP username:</div>
                        <div class="fw-semibold">{{ $masked ?? '—' }}</div>
                    </div>
                    <ul class="small text-muted mb-0">
                        <li>Your IMAP password is stored <strong>encrypted at rest</strong>.</li>
                        <li>We never display or log your password.</li>
                        <li>Prefer using an <strong>App Password</strong> if your provider supports it.</li>
                    </ul>
                </div>
                @if($connected)
                    <div class="card-footer">
                        <form method="post" action="{{ route('mailbox.disconnect') }}" onsubmit="return confirm('Disconnect mailbox?');">
                            @csrf
                            <button type="submit" class="btn btn-outline-danger w-100">Disconnect Mailbox</button>
                        </form>
                    </div>
                @endif
            </div>
        </div>

        {{-- Connect form --}}
        <div class="col-12 col-lg-7">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="m-0">Connect / Update Mailbox</h5>
                </div>
                <div class="card-body">
                    <form method="post" action="{{ route('mailbox.connect') }}" autocomplete="off" novalidate>
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">IMAP Email (Username)</label>
                            <input
                                type="email"
                                name="imap_username"
                                class="form-control @error('imap_username') is-invalid @enderror"
                                value="{{ old('imap_username', $user->imap_username) }}"
                                placeholder="name@yourdomain.com"
                                required
                            >
                            @error('imap_username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label d-flex align-items-center justify-content-between">
                                <span>IMAP Password</span>
                                <small class="text-muted">Use an <strong>App Password</strong> if available</small>
                            </label>
                            <div class="input-group">
                                <input
                                    type="password"
                                    name="imap_password"
                                    id="imap_password"
                                    class="form-control @error('imap_password') is-invalid @enderror"
                                    placeholder="••••••••"
                                    {{ $connected ? '' : 'required' }}
                                >
                                <button class="btn btn-outline-secondary" type="button" onclick="togglePass()">
                                    Show
                                </button>
                            </div>
                            @error('imap_password')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                            @if($connected)
                                <div class="form-text">Leave empty to keep the existing password.</div>
                            @endif
                        </div>

                        <div class="row g-2">
                            <div class="col-12 col-md-6">
                                <button type="submit" class="btn btn-primary w-100">
                                    {{ $connected ? 'Update Connection' : 'Connect Mailbox' }}
                                </button>
                            </div>
                            <div class="col-12 col-md-6">
                                <a href="{{ route('email.inbox') }}" class="btn btn-outline-primary w-100">Go to Inbox</a>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-footer small text-muted">
                    Server: {{ env('IMAP_HOST') }} • Port: {{ env('IMAP_PORT', 993) }} • Encryption: {{ strtoupper(env('IMAP_ENCRYPTION','ssl')) }}
                </div>
            </div>
        </div>
    </div>
</div>

{{-- tiny JS for show/hide password --}}
@push('scripts')
<script>
function togglePass(){
    const i = document.getElementById('imap_password');
    const btn = event.currentTarget;
    if(!i) return;
    i.type = (i.type === 'password') ? 'text' : 'password';
    btn.textContent = (i.type === 'password') ? 'Show' : 'Hide';
}
</script>
@endpush
@endsection
