@extends('layout.default', [
  'appClass' => 'app-content-full-height',
  'appContentClass' => 'p-3'
])

@section('title', 'Mail Detail')

@section('content')
@php
  $folder     = $folder ?? ($sideFolder ?? 'INBOX');
  $isUnread   = empty($seen);
  $attCount   = is_array($attachments ?? null) ? count($attachments) : 0;

  // Sidebar pagination (جاية من الكنترولر)
  $sp    = $sidePagination['page']  ?? 1;
  $sl    = $sidePagination['limit'] ?? 30;

  // Helpers
  function buildQuery($folder, $sp, $sl, array $extra = []) {
      return array_filter(array_merge([
          'folder' => $folder,
          'sp'     => $sp,
          'sl'     => $sl,
      ], $extra), fn($v) => $v !== null && $v !== '');
  }
  function inboxUrlDet($folder, $sp, $sl) {
      return route('email.inbox', buildQuery($folder, $sp, $sl));
  }
  function attUrlDet($uid, $index, $folder) {
      $url = route('email.attachment', ['uid' => $uid, 'index' => $index]);
      return $folder ? ($url.'?folder='.urlencode($folder)) : $url;
  }
@endphp

<div class="card h-100">
  <div class="mailbox">

    <!-- Toolbar -->
    <div class="mailbox-toolbar d-flex align-items-center flex-wrap gap-2">
      <a href="{{ inboxUrlDet($folder, $sp, $sl) }}" class="btn btn-outline-secondary btn-sm">
        <i class="fa fa-arrow-left me-1"></i> Back to {{ $folder }}
      </a>

      <div class="ms-auto d-flex gap-2">
        <form method="post" action="{{ route('email.markRead') }}">
          @csrf
          <input type="hidden" name="uid" value="{{ $uid }}">
          @if($folder)<input type="hidden" name="folder" value="{{ $folder }}">@endif
          <button class="btn btn-outline-success btn-sm" type="submit">
            <i class="fa fa-envelope-open me-1"></i> Mark read
          </button>
        </form>

        <form method="post" action="{{ route('email.markUnread') }}">
          @csrf
          <input type="hidden" name="uid" value="{{ $uid }}">
          @if($folder)<input type="hidden" name="folder" value="{{ $folder }}">@endif
          <button class="btn btn-outline-warning btn-sm" type="submit">
            <i class="fa fa-envelope me-1"></i> Mark unread
          </button>
        </form>

        <a href="{{ route('email.compose') }}" class="btn btn-outline-primary btn-sm">
          <i class="fa fa-reply me-1"></i> Reply
        </a>
      </div>
    </div>

    <!-- Body with sidebar + content -->
    <div class="mailbox-body d-flex">

      <!-- Sidebar (mini inbox) => Partial موحّد -->
      @include('email.partials.mini-inbox', [
  'sideItems'      => $sideItems ?? [],
  'sidePagination' => $sidePagination ?? ['page'=>1,'pages'=>1,'limit'=>30],
  'sideFolder'     => $sideFolder ?? $folder ?? 'INBOX',
  'sideActiveUid'  => $sideActiveUid ?? $uid ?? null,
  'showPagination' => true,
  'sidebarWidth'   => 360,  // initial
  'minWidth'       => 260,
  'maxWidth'       => 640,
  'resizable'      => true,
  // 'fullWidth'    => false, // لو عايز تعطل العمود التاني وتخليها تاخد العرض كله، فعّل ده
])

      <!-- Detail content -->
      <div class="mailbox-content flex-fill">
        <div data-scrollbar="true" data-height="100%">
          <div class="mailbox-detail">

            <!-- Header -->
            <div class="mailbox-detail-header">
              <div class="d-flex">
                <div class="flex-fill">
                  <div class="d-lg-flex align-items-start justify-content-between">
                    <div class="flex-1 pe-lg-3">
                      <h4 class="mb-2">
                        {{ $subject ?? '(No subject)' }}
                        @if($isUnread)
                          <span class="badge bg-success align-middle">New</span>
                        @endif
                        @if($attCount > 0)
                          <span class="badge bg-secondary align-middle">{{ $attCount }} attachment{{ $attCount>1?'s':'' }}</span>
                        @endif
                      </h4>

                      <div class="mb-1">
                        <div class="text-muted small">From</div>
                        <div class="fw-semibold">{{ $from ?: '(unknown)' }}</div>
                      </div>

                      <div class="mb-1">
                        <div class="text-muted small">To</div>
                        <div class="fw-semibold">{{ $to ?: '—' }}</div>
                      </div>

                      @if(!empty($cc))
                        <div class="mb-1">
                          <div class="text-muted small">Cc</div>
                          <div class="fw-semibold">{{ $cc }}</div>
                        </div>
                      @endif

                      @if(!empty($bcc))
                        <div class="mb-1">
                          <div class="text-muted small">Bcc</div>
                          <div class="fw-semibold">{{ $bcc }}</div>
                        </div>
                      @endif
                    </div>

                    <div class="text-lg-end mt-3 mt-lg-0">
                      <div class="text-white text-opacity-50 small">{{ $date ?? '' }}</div>
                      <div class="text-white text-opacity-50 small">Folder: <span class="fw-semibold">{{ $folder }}</span></div>
                      <div class="text-white text-opacity-50 small">UID: <span class="fw-semibold">{{ $uid }}</span></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Content -->
            <div class="mailbox-detail-content">
              @if($attCount > 0)
                <div class="mailbox-detail-attachment mb-3">
                  @foreach($attachments as $i => $att)
                    @php
                      $name = $att['name'] ?? ('attachment-'.$i);
                      $mime = $att['mime'] ?? null;
                      $size = $att['size'] ?? null;
                    @endphp
                    <div class="mailbox-attachment">
                      <a href="{{ attUrlDet($uid, $i, $folder) }}">
                        <div class="document-file">
                          @if(is_string($mime) && str_starts_with($mime, 'image/'))
                            <i class="fa fa-file-image"></i>
                          @elseif(is_string($mime) && str_starts_with($mime, 'video/'))
                            <i class="fa fa-file-video"></i>
                          @elseif(is_string($mime) && (str_contains($mime,'zip') || str_contains($mime,'compressed')))
                            <i class="fa fa-file-archive"></i>
                          @elseif(is_string($mime) && (str_contains($mime,'pdf')))
                            <i class="fa fa-file-pdf"></i>
                          @elseif(is_string($mime) && (str_contains($mime,'msword') || str_contains($mime,'officedocument')))
                            <i class="fa fa-file-word"></i>
                          @else
                            <i class="fa fa-file"></i>
                          @endif
                        </div>
                        <div class="document-name">
                          {{ $name }}
                          @if($size) <span class="text-muted small">({{ number_format($size/1024, 1) }} KB)</span> @endif
                        </div>
                      </a>
                    </div>
                  @endforeach
                </div>
                <div class="mb-3">
                  <a href="{{ attUrlDet($uid, 0, $folder) }}" class="btn btn-rounded px-3 btn-sm bg-theme bg-opacity-20 text-theme fw-600 rounded">
                    Download first
                  </a>
                </div>
              @endif

              <div class="mailbox-detail-body">
                @if(!empty($safeHtml))
                  {!! $safeHtml !!}
                @elseif(!empty($text))
                  <pre class="mb-0" style="white-space: pre-wrap; font-family: var(--bs-body-font-family);">{{ e($text) }}</pre>
                @else
                  <div class="text-muted">No content.</div>
                @endif
              </div>
            </div>
            <!-- /Content -->

          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>
@endsection
