@extends('layout.default', [
  'appClass' => 'app-content-full-height',
  'appContentClass' => 'p-3'
])

@section('title', 'Inbox')

@section('content')
@php
  // من الكنترولر:
  // 'items' => array of ['uid','subject','from','date','seen','has_attachments']
  // 'pagination' => ['page','limit','total','pages']
  // 'folder' => current folder name/path
  $page   = $pagination['page']   ?? 1;
  $limit  = $pagination['limit']  ?? 25;
  $total  = $pagination['total']  ?? 0;
  $pages  = $pagination['pages']  ?? 1;
  $folder = $folder ?? 'INBOX';

  $prev = max(1, $page - 1);
  $next = min($pages, $page + 1);

  // دالة مساعدة بسيطة لبناء رابط مع بارامترز
  function inboxUrl($page, $limit, $folder) {
      $q = ['page' => $page, 'limit' => $limit];
      if (!empty($folder)) $q['folder'] = $folder;
      return route('email.inbox', $q);
  }
@endphp

<!-- BEGIN card -->
<div class="card h-100">
  <!-- BEGIN mailbox -->
  <div class="mailbox">

    <!-- BEGIN mailbox-toolbar -->
    <div class="mailbox-toolbar d-flex align-items-center flex-wrap gap-2">
      <div class="mailbox-toolbar-item">
        <span class="mailbox-toolbar-text">Mailboxes</span>
      </div>

      <div class="mailbox-toolbar-item">
        <a href="{{ route('email.inbox', ['folder' => $folder]) }}" class="mailbox-toolbar-link active">
          {{ $folder ?: 'Inbox' }}
        </a>
      </div>

      {{-- أمثلة تبويب ثابتة (يمكن لاحقًا استبدالها بقائمة فولدرات ديناميكية) --}}
      <div class="mailbox-toolbar-item"><a href="{{ route('email.inbox') }}" class="mailbox-toolbar-link">Inbox</a></div>
      <div class="mailbox-toolbar-item"><a href="{{ route('email.inbox', ['folder' => 'Sent']) }}" class="mailbox-toolbar-link">Sent</a></div>
      <div class="mailbox-toolbar-item"><a href="{{ route('email.inbox', ['folder' => 'Drafts']) }}" class="mailbox-toolbar-link">Drafts</a></div>
      <div class="mailbox-toolbar-item"><a href="{{ route('email.inbox', ['folder' => 'Junk']) }}" class="mailbox-toolbar-link">Junk</a></div>

      <div class="ms-auto mailbox-toolbar-item">
        <a href="{{ route('email.compose') }}" class="mailbox-toolbar-link text-inverse bg-inverse bg-opacity-15">
          New Message <i class="fa fa-pen fs-12px ms-1"></i>
        </a>
      </div>
    </div>
    <!-- END mailbox-toolbar -->

    <!-- BEGIN mailbox-body -->
    <div class="mailbox-body d-flex">

      {{-- Sidebar (mini inbox) كـ Partial موحّد --}}
      @include('email.partials.mini-inbox', [
  'sideItems'      => $items,
  'sidePagination' => ['page' => $page, 'pages' => $pages, 'limit' => $limit],
  'sideFolder'     => $folder,
  'sideActiveUid'  => null,
  'showPagination' => false,
  'sidebarWidth'   => 360,
  'minWidth'       => 260,
  'maxWidth'       => 640,
  'resizable'      => true,
  // 'fullWidth'    => true, // مثال: خليها تاخد العرض كله في inbox لو عايز
])


      <!-- (اختياري) Pane للمعاينة السريعة -->
      <div class="mailbox-content flex-fill border-start d-none d-lg-flex align-items-center justify-content-center">
        <div class="text-muted">Select a message to preview.</div>
      </div>
    </div>
    <!-- END mailbox-body -->

    <!-- Pagination (عام للـ Inbox) -->
    <div class="d-flex align-items-center justify-content-between p-2 border-top">
      <div class="small text-muted">
        Showing page {{ $page }} of {{ $pages }} — total {{ $total }}
      </div>
      <div class="btn-group">
        <a class="btn btn-outline-secondary btn-sm {{ $page <= 1 ? 'disabled' : '' }}" href="{{ $page <= 1 ? '#' : inboxUrl($prev, $limit, $folder) }}">Prev</a>
        <a class="btn btn-outline-secondary btn-sm {{ $page >= $pages ? 'disabled' : '' }}" href="{{ $page >= $pages ? '#' : inboxUrl($next, $limit, $folder) }}">Next</a>
      </div>
    </div>

  </div>
  <!-- END mailbox -->

  <!-- BEGIN card-arrow -->
  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
  <!-- END card-arrow -->
</div>
<!-- END card -->
@endsection
