{{-- resources/views/email/partials/mini-inbox.blade.php --}}
@php
    use Illuminate\Support\Str;

    // Expected inputs (with defaults):
    // $sideItems, $sidePagination = ['page','pages','limit'], $sideFolder, $sideActiveUid
    // Optional controls:
    $sidebarWidth = isset($sidebarWidth) ? (int)$sidebarWidth : 360;
    $minWidth     = isset($minWidth)     ? (int)$minWidth     : 260;
    $maxWidth     = isset($maxWidth)     ? (int)$maxWidth     : 640;
    $resizable    = isset($resizable)    ? (bool)$resizable    : true;
    $fullWidth    = isset($fullWidth)    ? (bool)$fullWidth    : false;

    $items      = $sideItems        ?? [];
    $pagination = $sidePagination   ?? ['page'=>1,'pages'=>1,'limit'=>30];
    $folder     = $sideFolder       ?? 'INBOX';
    $activeUid  = $sideActiveUid    ?? null;
    $sp         = (int)($pagination['page']  ?? 1);
    $sl         = (int)($pagination['limit'] ?? 30);
    $pgs        = (int)($pagination['pages'] ?? 1);
    $withPager  = array_key_exists('showPagination', get_defined_vars()) ? (bool)$showPagination : true;

    // Links
    $detailUrl = function ($uid) use ($folder, $sp, $sl) {
        return route('email.detail', $uid) . '?' . http_build_query([
            'folder' => $folder,
            'sp'     => $sp,
            'sl'     => $sl,
        ]);
    };
    $prev = max(1, $sp - 1);
    $next = min($pgs, $sp + 1);

    // Unique keys for DOM & storage
    $resKey     = $resizerKey ?? ('mini-inbox-'.Str::random(6));
    $storageKey = 'miniInboxWidth:'.md5($folder ?: 'INBOX');
@endphp

@once
<style>
  /* Resizable sidebar styles (injected once) */
  .miniInbox {
    position: relative;
    flex: 0 0 auto;
    display: block !important;
  }
  .miniInbox .yg-resize-handle {
    position: absolute;
    right: -6px;
    top: 0;
    width: 12px;
    height: 100%;
    cursor: col-resize;
    z-index: 5;
  }
  .miniInbox .yg-resize-handle::before {
    content: "";
    position: absolute;
    left: 50%;
    top: 50%;
    width: 2px;
    height: 40px;
    transform: translate(-50%, -50%);
    background: rgba(255,255,255,.25);
    border-radius: 1px;
  }
  .miniInbox.resizing, .miniInbox.resizing * {
    user-select: none !important;
  }
  /* Full width mode */
  .miniInbox.is-full {
    width: 100% !important;
    min-width: auto !important;
    max-width: none !important;
    flex: 1 1 auto !important;
  }
</style>
@endonce

<div
  class="mailbox-sidebar miniInbox {{ $fullWidth ? 'is-full' : '' }}"
  data-mini-inbox="{{ $resKey }}"
  data-min="{{ $minWidth }}"
  data-max="{{ $maxWidth }}"
  style="
    {{ $fullWidth
        ? 'width:100%;min-width:auto;max-width:none;'
        : 'width:'.$sidebarWidth.'px;min-width:'.$sidebarWidth.'px;max-width:'.$maxWidth.'px;' }}
    display:block !important;"
>
  {{-- Resize handle (desktop only) --}}
  @if($resizable && !$fullWidth)
    <div class="yg-resize-handle" role="separator" aria-label="Resize sidebar" aria-orientation="vertical" tabindex="0"></div>
  @endif

  <div class="mailbox-list">
    @forelse($items as $it)
      @php
        $uid     = $it['uid']  ?? null;
        $unread  = empty($it['seen']);
        $hasAtt  = !empty($it['has_attachments']);
        $from    = $it['from'] ?? '';
        $date    = $it['date'] ?? '';
        $subject = $it['subject'] ?? '(No subject)';
        $active  = ($activeUid !== null && $uid == $activeUid);
      @endphp

      <div class="mailbox-list-item {{ $active ? 'active' : '' }} {{ $unread ? 'unread' : '' }} {{ $hasAtt ? 'has-attachment' : '' }}">
        <div class="mailbox-checkbox">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="" />
          </div>
        </div>
        <div class="mailbox-message">
          <a href="{{ $detailUrl($uid) }}" class="mailbox-list-item-link">
            <div class="mailbox-sender">
              <span class="mailbox-sender-name">{{ $from ?: '(no sender)' }}</span>
              <span class="mailbox-time">{{ $date }}</span>
            </div>
            <div class="d-flex align-items-center gap-2">
              <div class="mailbox-title">{{ \Illuminate\Support\Str::limit($subject, 60) }}</div>
              @if($hasAtt)<i class="fa fa-paperclip small text-muted"></i>@endif
              @if($unread)<span class="badge bg-success">New</span>@endif
            </div>
          </a>
        </div>
      </div>
    @empty
      <div class="p-3 text-muted">No messages.</div>
    @endforelse
  </div>

  @if($withPager)
    <div class="d-flex align-items-center justify-content-between p-2 border-top">
      <div class="small text-muted">Page {{ $sp }} / {{ $pgs }}</div>
      <div class="btn-group">
        <a class="btn btn-outline-secondary btn-sm {{ $sp <= 1 ? 'disabled' : '' }}"
           href="{{ $sp <= 1 ? '#' : (route('email.detail', $activeUid) . '?' . http_build_query(['folder'=>$folder,'sp'=>$prev,'sl'=>$sl])) }}">Prev</a>
        <a class="btn btn-outline-secondary btn-sm {{ $sp >= $pgs ? 'disabled' : '' }}"
           href="{{ $sp >= $pgs ? '#' : (route('email.detail', $activeUid) . '?' . http_build_query(['folder'=>$folder,'sp'=>$next,'sl'=>$sl])) }}">Next</a>
      </div>
    </div>
  @endif
</div>

@once
<script>
(function() {
  function initMiniInbox(key, storageKey) {
    var el = document.querySelector('[data-mini-inbox="'+key+'"]');
    if (!el) return;

    var handle = el.querySelector('.yg-resize-handle');
    if (!handle) return; // not resizable or fullWidth

    var min = parseInt(el.dataset.min || '260', 10);
    var max = parseInt(el.dataset.max || '640', 10);

    // Apply saved width
    try {
      var saved = localStorage.getItem(storageKey);
      if (saved) {
        var w = Math.max(min, Math.min(max, parseInt(saved, 10)));
        el.style.width = w+'px';
        el.style.minWidth = w+'px';
      }
    } catch (e) {}

    var startX = 0, startW = 0, moving = false;

    function onMove(e) {
      if (!moving) return;
      var dx = e.clientX - startX;
      var w  = Math.max(min, Math.min(max, startW + dx));
      el.style.width = w + 'px';
      el.style.minWidth = w + 'px';
      try { localStorage.setItem(storageKey, String(w)); } catch (e) {}
    }
    function onUp() {
      moving = false;
      el.classList.remove('resizing');
      document.removeEventListener('mousemove', onMove);
      document.removeEventListener('mouseup', onUp);
    }
    handle.addEventListener('mousedown', function(e) {
      // ignore on touch devices (optional)
      if (e.buttons !== 1) return;
      moving = true;
      el.classList.add('resizing');
      startX = e.clientX;
      startW = el.getBoundingClientRect().width;
      document.addEventListener('mousemove', onMove);
      document.addEventListener('mouseup', onUp);
      e.preventDefault();
    });

    // Keyboard accessibility (Left/Right arrows)
    handle.addEventListener('keydown', function(e) {
      var step = (e.shiftKey ? 40 : 10);
      var w = el.getBoundingClientRect().width;
      if (e.key === 'ArrowLeft') {
        w = Math.max(min, w - step);
      } else if (e.key === 'ArrowRight') {
        w = Math.min(max, w + step);
      } else {
        return;
      }
      el.style.width = w+'px';
      el.style.minWidth = w+'px';
      try { localStorage.setItem(storageKey, String(w)); } catch (e) {}
      e.preventDefault();
    });
  }

  // Initialize current partial instance
  initMiniInbox("{{ $resKey }}", "{{ $storageKey }}");
})();
</script>
@endonce
