@extends('layout.default', [
  'appClass' => 'app-content-full-height',
  'appContentClass' => 'p-3'
])

@section('title', 'DNS Health')

@section('content')
@php
  $r = $report ?? [];
  $badge = fn($ok) => $ok ? '<span class="badge bg-success">PASS</span>' : '<span class="badge bg-danger">FAIL</span>';
  $safe = fn($s) => e($s ?? '—');
@endphp

<div class="card h-100">
  <div class="mailbox">
    <div class="mailbox-toolbar d-flex align-items-center flex-wrap gap-2">
      <div class="mailbox-toolbar-item">
        <span class="mailbox-toolbar-text">DNS Health Checklist</span>
      </div>
      <div class="ms-auto">
        <form method="get" action="{{ route('email.tools.dns') }}" class="d-flex gap-2">
          <input type="text" class="form-control form-control-sm" name="domain" value="{{ $domain }}" placeholder="example.com">
          <input type="text" class="form-control form-control-sm" name="mail_host" value="{{ $mailHost }}" placeholder="mail.example.com">
          <button class="btn btn-outline-secondary btn-sm"><i class="fa fa-sync me-1"></i> Re-run</button>
        </form>
      </div>
    </div>

    <div class="mailbox-body">
      <div class="mailbox-content">
        <div data-scrollbar="true" data-height="100%" class="p-3">
          <div class="row g-3">

            <!-- Mail host A/AAAA -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">Mail Host (A/AAAA)</h5>
                  <div class="mb-2">
                    <strong>Host:</strong> <code>{{ $mailHost ?: '—' }}</code>
                  </div>
                  <div class="mb-2">
                    <strong>Status:</strong> {!! $badge($r['a']['ok'] ?? false) !!}
                  </div>
                  <div class="small text-muted">IPs:
                    @if(!empty($r['a']['ips']))
                      @foreach($r['a']['ips'] as $ip)<code class="me-1">{{ $ip }}</code>@endforeach
                    @else
                      —
                    @endif
                  </div>
                </div>
              </div>
            </div>

            <!-- PTR -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">Reverse DNS (PTR)</h5>
                  <div class="mb-2"><strong>IP:</strong> <code>{{ $r['ptr']['ip'] ?? '—' }}</code></div>
                  <div class="mb-2"><strong>Status:</strong> {!! $badge($r['ptr']['ok'] ?? false) !!}</div>
                  <div class="small text-muted">PTR: <code>{{ $r['ptr']['value'] ?? '—' }}</code></div>
                  <div class="text-muted small mt-2">Tip: يُفضّل أن يشير PTR إلى {{ $mailHost ?: 'mail host' }}.</div>
                </div>
              </div>
            </div>

            <!-- MX -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">MX ({{ $domain }})</h5>
                  <div class="mb-2"><strong>Status:</strong> {!! $badge($r['mx']['ok'] ?? false) !!}</div>
                  @if(!empty($r['mx']['rows']))
                    <table class="table table-sm align-middle mb-0">
                      <thead><tr><th>Priority</th><th>Host</th></tr></thead>
                      <tbody>
                        @foreach($r['mx']['rows'] as $mx)
                          <tr><td>{{ $mx['prio'] }}</td><td><code>{{ $mx['host'] }}</code></td></tr>
                        @endforeach
                      </tbody>
                    </table>
                  @else
                    <div class="text-muted small">No MX records found.</div>
                  @endif
                </div>
              </div>
            </div>

            <!-- SPF -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">SPF</h5>
                  <div class="mb-2">
                    <strong>Exists:</strong> {!! $badge($r['spf']['exist'] ?? false) !!}
                  </div>
                  <div class="mb-2">
                    <strong>Authorizes sender:</strong> {!! $badge($r['spf']['ok'] ?? false) !!}
                  </div>
                  <div class="small text-muted">Policy:
                    <code>{{ $r['spf']['policy'] ?? '—' }}</code>
                  </div>
                  <div class="small mt-2">Raw:
                    <code class="d-block" style="white-space: pre-wrap">{{ $r['spf']['raw'] ?? '—' }}</code>
                  </div>
                  <div class="text-muted small mt-2">
                    Tip: تأكد أن الـ SPF يسمح بخادمك (ip4، أو mx/a، أو include).
                  </div>
                </div>
              </div>
            </div>

            <!-- DKIM -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">DKIM (selector: default)</h5>
                  <div class="mb-2"><strong>Host:</strong> <code>{{ $r['dkim']['host'] ?? '—' }}</code></div>
                  <div class="mb-2"><strong>Status:</strong> {!! $badge($r['dkim']['ok'] ?? false) !!}</div>
                  <div class="small mt-2">Raw:
                    <code class="d-block" style="white-space: pre-wrap">{{ $r['dkim']['raw'] ?? '—' }}</code>
                  </div>
                  <div class="text-muted small mt-2">
                    Tip: فعّل DKIM من cPanel → Email Deliverability (عادة record اسمه <code>default._domainkey</code>).
                  </div>
                </div>
              </div>
            </div>

            <!-- DMARC -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">DMARC</h5>
                  <div class="mb-2"><strong>Host:</strong> <code>{{ $r['dmarc']['host'] ?? '—' }}</code></div>
                  <div class="mb-2"><strong>Status:</strong> {!! $badge($r['dmarc']['ok'] ?? false) !!}</div>
                  <div class="small">Policy: <code>{{ $r['dmarc']['policy'] ?? '—' }}</code></div>
                  <div class="small">rua: <code>{{ $r['dmarc']['rua'] ?? '—' }}</code></div>
                  <div class="small">adkim/aspf: <code>{{ $r['dmarc']['adkim'] ?? '—' }}/{{ $r['dmarc']['aspf'] ?? '—' }}</code></div>
                  <div class="small mt-2">Raw:
                    <code class="d-block" style="white-space: pre-wrap">{{ $r['dmarc']['raw'] ?? '—' }}</code>
                  </div>
                  <div class="text-muted small mt-2">
                    Tip: ابدأ <code>p=none</code> ثم لاحقًا <code>quarantine</code> أو <code>reject</code> بعد ما تتأكد من ضبط SPF/DKIM.
                  </div>
                </div>
              </div>
            </div>

          </div><!-- /row -->

          <div class="alert alert-info mt-3">
            {{ $r['tips']['alignment'] ?? '' }}
          </div>

        </div>
      </div>
    </div>
  </div>

  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>
@endsection
