@extends('layout.default', [
  'appClass' => 'app-content-full-height',
  'appContentClass' => 'p-3'
])

@section('title', 'Mail Health')

@section('content')
@php
  $r = $report ?? [];
  $badge = fn($ok) => $ok ? '<span class="badge bg-success">PASS</span>' : '<span class="badge bg-danger">FAIL</span>';
@endphp

<div class="card h-100">
  <div class="mailbox">
    <div class="mailbox-toolbar d-flex align-items-center flex-wrap gap-2">
      <div class="mailbox-toolbar-item">
        <span class="mailbox-toolbar-text">Mail Health Checklist</span>
      </div>
      <div class="ms-auto">
        <a href="{{ route('email.tools.health') }}" class="btn btn-outline-secondary btn-sm">
          <i class="fa fa-sync me-1"></i> Re-run
        </a>
      </div>
    </div>

    <div class="mailbox-body">
      <div class="mailbox-content">
        <div data-scrollbar="true" data-height="100%" class="p-3">

          @if(session('ok'))
            <div class="alert alert-success">{{ session('ok') }}</div>
          @endif
          @if($errors->any())
            <div class="alert alert-danger">
              <ul class="mb-0">
                @foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach
              </ul>
            </div>
          @endif

          <div class="row g-3">
            <!-- ENV -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-3">Environment</h5>
                  <dl class="row mb-0">
                    <dt class="col-5">MAIL_HOST</dt><dd class="col-7">{{ $r['env']['MAIL_HOST'] ?? '—' }}</dd>
                    <dt class="col-5">MAIL_PORT</dt><dd class="col-7">{{ $r['env']['MAIL_PORT'] ?? '—' }}</dd>
                    <dt class="col-5">MAIL_ENCRYPTION</dt><dd class="col-7">{{ $r['env']['MAIL_ENCRYPTION'] ?? '—' }}</dd>
                    <dt class="col-5">MAIL_VERIFY_PEER</dt><dd class="col-7">{{ var_export($r['env']['MAIL_VERIFY_PEER'] ?? null, true) }}</dd>
                    <dt class="col-5">IMAP_HOST</dt><dd class="col-7">{{ $r['env']['IMAP_HOST'] ?? '—' }}</dd>
                    <dt class="col-5">IMAP_PORT</dt><dd class="col-7">{{ $r['env']['IMAP_PORT'] ?? '—' }}</dd>
                    <dt class="col-5">IMAP_ENCRYPTION</dt><dd class="col-7">{{ $r['env']['IMAP_ENCRYPTION'] ?? '—' }}</dd>
                    <dt class="col-5">IMAP_VALIDATE_CERT</dt><dd class="col-7">{{ var_export($r['env']['IMAP_VALIDATE_CERT'] ?? null, true) }}</dd>
                  </dl>
                </div>
              </div>
            </div>

            <!-- DNS / TCP -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-3">Network</h5>

                  <div class="mb-2">
                    <strong>DNS (SMTP):</strong>
                    {!! $badge($r['dns']['smtp']['ok'] ?? false) !!}
                    <div class="small text-muted">{{ $r['dns']['smtp']['host'] ?? '' }} → {{ $r['dns']['smtp']['ip'] ?? 'n/a' }}</div>
                  </div>

                  <div class="mb-2">
                    <strong>DNS (IMAP):</strong>
                    {!! $badge($r['dns']['imap']['ok'] ?? false) !!}
                    <div class="small text-muted">{{ $r['dns']['imap']['host'] ?? '' }} → {{ $r['dns']['imap']['ip'] ?? 'n/a' }}</div>
                  </div>

                  <div class="mb-2">
                    <strong>TCP (SMTP):</strong>
                    {!! $badge($r['tcp']['smtp']['ok'] ?? false) !!}
                    <div class="small text-muted">
                      @if(!empty($r['tcp']['smtp']['ok']))
                        {{ $r['tcp']['smtp']['ms'] ?? '?' }} ms
                      @else
                        {{ $r['tcp']['smtp']['error'] ?? 'n/a' }}
                      @endif
                    </div>
                  </div>

                  <div class="mb-0">
                    <strong>TCP (IMAP):</strong>
                    {!! $badge($r['tcp']['imap']['ok'] ?? false) !!}
                    <div class="small text-muted">
                      @if(!empty($r['tcp']['imap']['ok']))
                        {{ $r['tcp']['imap']['ms'] ?? '?' }} ms
                      @else
                        {{ $r['tcp']['imap']['error'] ?? 'n/a' }}
                      @endif
                    </div>
                  </div>

                </div>
              </div>
            </div>

            <!-- IMAP -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-3">IMAP Login (Per-User)</h5>
                  {!! $badge($r['imap']['ok'] ?? false) !!}
                  @if(!empty($r['imap']['ok']))
                    <div class="small text-muted mt-2">Folders count: {{ $r['imap']['folders'] ?? 0 }}</div>
                  @else
                    <div class="text-danger small mt-2">{{ $r['imap']['error'] ?? 'Unknown error' }}</div>
                  @endif
                </div>
              </div>
            </div>

            <!-- SMTP -->
            <div class="col-12 col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <h5 class="card-title mb-2">SMTP Transport</h5>
                  <div class="mb-1"><strong>DSN:</strong> <code>{{ $r['smtp']['dsn'] ?? '' }}</code></div>
                  <div class="mb-2">
                    <strong>Start:</strong>
                    {!! $badge($r['smtp']['ok'] ?? false) !!}
                    @if(empty($r['smtp']['ok']))
                      <div class="text-danger small mt-1">{{ $r['smtp']['error'] ?? 'Unknown error' }}</div>
                    @endif
                  </div>

                  <hr>

                  <form action="{{ route('email.tools.send') }}" method="post" class="mt-2">
                    @csrf
                    <div class="row g-2 align-items-end">
                      <div class="col-12">
                        <label class="form-label fw-500">Send Test Email</label>
                      </div>
                      <div class="col-md-6">
                        <input type="email" name="to" class="form-control" required
                               value="{{ old('to', $me->email ?? '') }}"
                               placeholder="you@example.com">
                      </div>
                      <div class="col-md-3">
                        <input type="text" name="subject" class="form-control"
                               value="{{ old('subject') }}" placeholder="Subject (optional)">
                      </div>
                      <div class="col-md-3 text-end">
                        <button class="btn btn-success">
                          <i class="fa fa-paper-plane me-1"></i> Send Test
                        </button>
                      </div>
                    </div>
                  </form>

                </div>
              </div>
            </div>

          </div><!-- /row -->

        </div>
      </div>
    </div>
  </div>

  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>
@endsection
