@extends('layout.default')

@section('title', 'Employee Performance - ' . ($employee->full_name ?? $employee->user->name))

{{-- Neon tokens + Toasts --}}
@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            color: var(--text-main);
        }

        /* Card */
        .card-n {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
        }

        .card-n .card-header {
            border-bottom: 1px solid var(--border);
            padding: 14px 16px;
        }

        .card-n .card-body {
            padding: 16px;
        }

        .neon-title {
            font-weight: 800;
            margin: 0;
            letter-spacing: .4px;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        .chip {
            display: inline-flex;
            gap: .45rem;
            align-items: center;
            padding: .28rem .6rem;
            border: 1px solid var(--border-2);
            border-radius: 999px;
            font-size: .8rem;
            background: rgba(0, 224, 255, .08);
            color: #cfe7ff;
        }

        /* Filters */
        .flt-wrap {
            display: flex;
            gap: .6rem;
            flex-wrap: wrap;
            align-items: center;
        }

        .flt-select,
        .flt-date {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .7rem;
            min-width: 160px;
            outline: none;
        }

        .flt-select:focus,
        .flt-date:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .55rem 1rem;
            border-radius: 10px;
            display: inline-flex;
            align-items: center;
            gap: .45rem;
            transition: .18s;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        /* KPIs */
        .kpi {
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(17, 27, 44, .9), rgba(10, 16, 32, .9)); */
        }

        .kpi .t {
            font-size: .8rem;
            color: var(--muted);
        }

        .kpi .v {
            font-weight: 800;
            font-size: 1.4rem;
        }

        .kpi--grad1 {
            background: linear-gradient(135deg, rgba(0, 224, 255, .16), rgba(255, 95, 255, .12));
        }

        .kpi--grad2 {
            background: linear-gradient(135deg, rgba(42, 252, 152, .16), rgba(0, 224, 255, .12));
        }

        .kpi--grad3 {
            background: linear-gradient(135deg, rgba(0, 224, 255, .14), rgba(40, 180, 255, .10));
        }

        .kpi--grad4 {
            background: linear-gradient(135deg, rgba(255, 185, 0, .14), rgba(255, 127, 39, .10));
        }

        /* Table */
        .tbl {
            border: 1px solid var(--border);
            border-radius: 12px;
            overflow: hidden;
        }

        table.neon {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            color: #dce7ff;
        }

        .neon thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            padding: 12px 14px;
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        .neon tbody td {
            padding: 12px 14px;
            border-bottom: 1px solid rgba(0, 224, 255, .08);
            vertical-align: middle;
        }

        .neon tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* Badges */
        .badge-n {
            display: inline-block;
            padding: .32rem .6rem;
            border-radius: 10px;
            font-weight: 700;
            font-size: .75rem;
            border: 1px solid transparent;
        }

        .b-info {
            background: linear-gradient(90deg, rgba(0, 224, 255, .20), rgba(255, 95, 255, .14));
            color: #e7fbff;
            border-color: rgba(0, 224, 255, .45);
        }

        .b-ok {
            background: linear-gradient(90deg, rgba(42, 252, 152, .22), rgba(0, 224, 255, .14));
            color: #dfffea;
            border-color: rgba(42, 252, 152, .45);
        }

        .b-warn {
            background: linear-gradient(90deg, rgba(255, 185, 0, .24), rgba(255, 127, 39, .16));
            color: #fff0c9;
            border-color: rgba(255, 185, 0, .45);
        }

        .b-danger {
            background: linear-gradient(90deg, rgba(255, 95, 95, .24), rgba(255, 0, 130, .16));
            color: #ffe6ea;
            border-color: rgba(255, 95, 95, .45);
        }

        @media(max-width:767px) {
            .tbl {
                overflow-x: auto;
            }
        }
    </style>
@endpush

@section('content')
    <div class="container-fluid">
        <div class="card-n">
            <div class="card-header">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center">
                    <div class="mb-3 mb-lg-0">
                        <h3 class="neon-title"><i class="fas fa-user mr-2"></i>
                            {{ $employee->full_name ?? $employee->user->name }}</h3>
                        <p class="sub-muted small mb-1">Employee performance and attendance tracking</p>
                        <p class="m-0 small">
                            Period:
                            <span class="chip">{{ $startDate->format('M d, Y') }}</span>
                            —
                            <span class="chip">{{ $endDate->format('M d, Y') }}</span>
                        </p>
                    </div>

                    {{-- Filters + Export --}}
                    <div class="d-flex flex-column flex-md-row align-items-md-center" style="gap:.6rem;">
                        <form method="GET" action="{{ url()->current() }}" class="flt-wrap">
                            <select name="filter" id="filter" class="flt-select" onchange="toggleCustomDates()">
                                <option value="day" {{ $filter == 'day' ? 'selected' : '' }}>Today</option>
                                <option value="week" {{ $filter == 'week' ? 'selected' : '' }}>This Week</option>
                                <option value="month" {{ $filter == 'month' ? 'selected' : '' }}>This Month</option>
                                <option value="custom"{{ $filter == 'custom' ? 'selected' : '' }}>Custom Range</option>
                            </select>
                            <div id="customDates" class="d-flex"
                                style="display: {{ $filter == 'custom' ? 'flex' : 'none' }} !important; gap:.6rem;">
                                <input type="date" name="custom_start" id="custom_start" class="flt-date"
                                    value="{{ request('custom_start') }}">
                                <input type="date" name="custom_end" id="custom_end" class="flt-date"
                                    value="{{ request('custom_end') }}">
                            </div>
                            <button type="submit" class="neon-btn"><i class="fas fa-filter"></i> Apply Filter</button>
                            <a href="{{ route('hr.attendance.employee-export', ['employeeId' => $employee->id, 'filter' => $filter ?? 'month', 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                                class="neon-btn"><i class="fas fa-download"></i> Export</a>
                        </form>


                    </div>
                </div>
            </div>

            <div class="card-body">
                {{-- KPIs --}}
                <div class="row g-3 mb-3">
                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi kpi--grad1">
                            <div class="t">Attendance Rate</div>
                            <div class="v">{{ $attendanceRate }}%</div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi kpi--grad2">
                            <div class="t">Days Attended</div>
                            <div class="v">{{ $totalAttendances }}</div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi kpi--grad3">
                            <div class="t">Total Work Days</div>
                            <div class="v">{{ $expectedDays }}</div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi kpi--grad4">
                            <div class="t">Avg Work Hours</div>
                            <div class="v">{{ $averageWorkHours ?? 'N/A' }}{{ $averageWorkHours ? 'h' : '' }}</div>
                        </div>
                    </div>
                </div>

                {{-- Attendance Records --}}
                <div class="tbl">
                    <table class="neon">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Check In</th>
                                <th>Check Out</th>
                                <th>Working Hours</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($attendances->count() > 0)
                                @foreach ($attendances as $attendance)
                                    @php
                                        $checkTime = \Carbon\Carbon::parse($attendance->check_time);
                                        $statusClass = 'b-info';
                                        if ($attendance->status === 'present') {
                                            $statusClass = 'b-ok';
                                        } elseif ($attendance->status === 'late') {
                                            $statusClass = 'b-warn';
                                        } elseif ($attendance->status === 'absent') {
                                            $statusClass = 'b-danger';
                                        }
                                    @endphp
                                    <tr>
                                        <td>
                                            <strong>{{ $checkTime->format('M d, Y') }}</strong><br>
                                            <small class="sub-muted">{{ $checkTime->format('l') }}</small>
                                        </td>

                                        <td>
                                            @if (isset($attendance->check_in) && $attendance->check_in)
                                                <span class="badge-n b-ok"><i
                                                        class="fas fa-sign-in-alt mr-1"></i>{{ \Carbon\Carbon::parse($attendance->check_in)->format('H:i') }}</span>
                                            @elseif($attendance->status === 'present')
                                                <span class="badge-n b-info"><i
                                                        class="fas fa-sign-in-alt mr-1"></i>{{ $checkTime->format('H:i') }}</span>
                                            @else
                                                <span class="badge-n b-warn"><i class="fas fa-minus mr-1"></i>No
                                                    Check-in</span>
                                            @endif
                                        </td>

                                        <td>
                                            @if (isset($attendance->check_out) && $attendance->check_out)
                                                <span class="badge-n b-info"><i
                                                        class="fas fa-sign-out-alt mr-1"></i>{{ \Carbon\Carbon::parse($attendance->check_out)->format('H:i') }}</span>
                                            @elseif($attendance->status === 'present')
                                                <span class="badge-n b-warn"><i
                                                        class="fas fa-exclamation-triangle mr-1"></i>Still Active</span>
                                            @else
                                                <span class="badge-n b-warn"><i class="fas fa-minus mr-1"></i>No
                                                    Check-out</span>
                                            @endif
                                        </td>

                                        <td>
                                            @if ($attendance->hours_worked && $attendance->hours_worked > 0)
                                                <span class="badge-n b-info"><i
                                                        class="fas fa-clock mr-1"></i>{{ number_format($attendance->hours_worked, 1) }}h</span>
                                            @else
                                                <span class="badge-n b-warn"><i class="fas fa-minus mr-1"></i>N/A</span>
                                            @endif
                                        </td>

                                        <td>
                                            <span class="badge-n {{ $statusClass }}">
                                                @switch($attendance->status)
                                                    @case('present')
                                                        <i class="fas fa-check mr-1"></i>Present
                                                    @break

                                                    @case('late')
                                                        <i class="fas fa-exclamation mr-1"></i>Late
                                                    @break

                                                    @case('absent')
                                                        <i class="fas fa-times mr-1"></i>Absent
                                                    @break

                                                    @default
                                                        <i class="fas fa-question mr-1"></i>Unknown
                                                @endswitch
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center py-4">
                                        <i class="fas fa-calendar-times fa-2x sub-muted mb-2"></i>
                                        <div class="sub-muted">No attendance records found</div>
                                        <small class="sub-muted">
                                            {{ $employee->full_name ?? $employee->user->name }} has no attendance records
                                            in the selected period.
                                        </small>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        function toggleCustomDates() {
            const v = document.getElementById('filter')?.value;
            const box = document.getElementById('customDates');
            if (!box) return;
            box.style.display = (v === 'custom') ? 'flex' : 'none';
        }
        document.querySelector('form.flt-wrap')?.addEventListener('submit', () => {
            window.toast?.info('Filter Applied', 'Reloading records…', 1200);
        });
    </script>
@endpush
