@extends('layout.default')

@section('title', 'Manual Attendance Entry')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Manual Attendance Entry</h3>
                    <div class="card-tools">
                        <a href="{{ route('hr.attendance.dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Dashboard
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('hr.attendance.store-manual') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="employee_id">Employee</label>
                                    <select name="employee_id" id="employee_id" class="form-control" required>
                                        <option value="">Select Employee</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}">
                                                {{ $employee->full_name ?? $employee->user->name }}
                                                ({{ $employee->department->name ?? 'No Dept' }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" name="date" id="date" class="form-control"
                                           value="{{ date('Y-m-d') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="check_in_time">Check In Time</label>
                                    <input type="time" name="check_in_time" id="check_in_time"
                                           class="form-control" value="09:00" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="check_out_time">Check Out Time (Optional)</label>
                                    <input type="time" name="check_out_time" id="check_out_time"
                                           class="form-control" value="17:00">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Attendance
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Bulk Entry -->
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-title">Bulk Attendance Entry</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('hr.attendance.bulk-entry') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bulk_date">Date</label>
                                    <input type="date" name="bulk_date" id="bulk_date" class="form-control"
                                           value="{{ date('Y-m-d') }}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="department_id">Department</label>
                                    <select name="department_id" id="department_id" class="form-control" required>
                                        <option value="">Select Department</option>
                                        @foreach($departments as $dept)
                                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="attendance_percentage">Attendance Percentage</label>
                                    <select name="attendance_percentage" class="form-control" required>
                                        <option value="100">100% (All Present)</option>
                                        <option value="90">90% Present</option>
                                        <option value="80">80% Present</option>
                                        <option value="70">70% Present</option>
                                        <option value="60">60% Present</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-users"></i> Create Bulk Attendance
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection