@extends('layout.default')

@section('content')
    <div class="card shadow">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5>🔎 HR - Advanced User Management</h5>
        </div>

        <div class="card-body">
            <form id="searchForm" class="row g-2 mb-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="Search by name..."
                        value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="department_id" class="form-select">
                        <option value="">All Departments</option>
                        @foreach ($departments as $dept)
                            <option value="{{ $dept->id }}" @selected(request('department_id') == $dept->id)>
                                {{ $dept->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="email_status" class="form-select">
                        <option value="">Email Status</option>
                        <option value="has" @selected(request('email_status') == 'has')>Has Email</option>
                        <option value="missing" @selected(request('email_status') == 'missing')>Missing Email</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">All</option>
                        <option value="active" @selected(request('status') == 'active')>Active</option>
                        <option value="inactive" @selected(request('status') == 'inactive')>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">Search</button>
                </div>
            </form>

            <div id="usersTable">
                @include('hr.users.partials.table')
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("searchForm");
            form.addEventListener("submit", function(e) {
                e.preventDefault();
                fetchResults();
            });

            function fetchResults(page = 1) {
                const formData = new FormData(form);
                const params = new URLSearchParams(formData).toString();
                fetch(`{{ route('hr.users.index') }}?${params}`, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(res => res.text())
                    .then(html => {
                        document.getElementById('usersTable').innerHTML = html;
                    });
            }

            // Pagination click
            document.addEventListener('click', function(e) {
                if (e.target.closest('.pagination a')) {
                    e.preventDefault();
                    const url = new URL(e.target.href);
                    fetchResults(url.searchParams.get('page'));
                }
            });
        });
    </script>
@endpush
