<table class="table table-striped table-hover align-middle">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Name</th>
            <th>Employee Name</th>
            <th>Department</th>
            <th>Email</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($users as $user)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->employee?->full_name ?? '—' }}</td>
                <td>{{ $user->employee?->department?->name ?? '—' }}</td>
                <td>{{ $user->email ?: '—' }}</td>
                <td>
                    <span class="badge {{ $user->status ? 'bg-success' : 'bg-secondary' }}">
                        {{ $user->status ? 'Active' : 'Inactive' }}
                    </span>
                </td>
                <td>
                    <a href="{{ route('hr.users.edit', $user->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="7" class="text-center text-muted">No users found</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="mt-3">
    {{ $users->links() }}
</div>
