@extends('layout.default', [
	'appClass' => 'app-content-full-height',
	'appContentClass' => 'p-0'
])

@section('title', 'Calendar')

@push('js')
	<script src="/assets/plugins/moment/moment.js"></script>
	<script src="/assets/plugins/@fullcalendar/core/index.global.min.js"></script>
	<script src="/assets/plugins/@fullcalendar/daygrid/index.global.min.js"></script>
	<script src="/assets/plugins/@fullcalendar/timegrid/index.global.min.js"></script>
	<script src="/assets/plugins/@fullcalendar/list/index.global.min.js"></script>
	<script src="/assets/plugins/@fullcalendar/bootstrap/index.global.min.js"></script>
	<script src="/assets/plugins/@fullcalendar/interaction/index.global.min.js"></script>
	<script src="/assets/js/demo/calendar.demo.js"></script>
@endpush

@section('content')
  <!-- BEGIN calendar -->
	<div class="calendar">
		<!-- BEGIN calendar-body -->
		<div class="calendar-body">
			<div data-scrollbar="true" data-height="100%">
				<div id="calendar"></div>
			</div>
		</div>
		<!-- ENG calendar-body -->
		<!-- BEGIN calendar-sidebar -->
		<div class="calendar-sidebar p-0">
			<div class="p-3" data-scrollbar="true" data-height="100%">
				<div class="calendar-sidebar-title">Draggable Events:</div>
				<div class="fc-event-list" id="external-events">
					<div class="fc-event-item"><div class="fc-event-link" data-color="#ff2d55"><i class="fa fa-circle fs-8px me-2 text-pink"></i> Meeting</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#ff3b30"><i class="fa fa-circle fs-8px me-2 text-danger"></i> Group Discussion</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#FF9500"><i class="fa fa-circle fs-8px me-2 text-warning"></i> Brainstorming</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#FFCC00"><i class="fa fa-circle fs-8px me-2 text-yellow"></i> Presentation</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#1ABD36"><i class="fa fa-circle fs-8px me-2 text-success"></i> Holiday</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#0cd096"><i class="fa fa-circle fs-8px me-2 text-theme"></i> Sick Leave</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#30beff"><i class="fa fa-circle fs-8px me-2 text-info"></i> Overtime</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#1f6bff"><i class="fa fa-circle fs-8px me-2 text-blue"></i> Work from Home</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#640DF3"><i class="fa fa-circle fs-8px me-2 text-indigo"></i> Business Travel</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#5b2e91"><i class="fa fa-circle fs-8px me-2 text-purple"></i> Breakfast</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#869ac0"><i class="fa fa-circle fs-8px me-2 text-muted"></i> Lunch</div></div>
					<div class="fc-event-item"><div class="fc-event-link" data-color="#869ac0"><i class="fa fa-circle fs-8px me-2 text-muted"></i> Dinner</div></div>
				</div>
			</div>
		</div>
		<!-- ENG calendar-sidebar -->
	</div>
	<!-- end calendar -->
@endsection
