@extends('layout.default')

@section('content')
    <div class="container-fluid">
        {{-- Toasts container (top-right) --}}
        <div class="toast-container position-fixed top-0 end-0 p-3" id="toastContainer" style="z-index:1080;"></div>

        <div class="row g-3">
            {{-- Tree (AJAX) --}}
            <div class="col-md-4">
                <div class="card hud-card mb-3">
                    <div class="card-header hud-head d-flex justify-content-between align-items-center">
                        <strong class="neon-title">Departments</strong>
                        <div class="d-flex gap-2">
                            <input id="treeSearch" class="hud-input form-control form-control-sm" placeholder="Search..."
                                style="width: 160px">
                            <button class="btn btn-sm btn-neon" data-bs-toggle="modal" data-bs-target="#createDeptModal">+
                                Add</button>
                        </div>
                    </div>
                    <div id="deptTree" class="card-body p-2" style="max-height:70vh;overflow:auto">
                        <div class="skeleton skeleton-lines"></div>
                    </div>
                </div>
            </div>

            {{-- Employees (AJAX) --}}
            <div class="col-md-8">
                <div class="card hud-card">
                    <div class="card-header hud-head d-flex justify-content-between align-items-center">
                        <strong class="neon-title">Employees</strong>
                        <div class="d-flex gap-2">
                            <input id="empSearch" class="hud-input form-control form-control-sm"
                                placeholder="Search employees..." style="width:220px">
                            {{-- @role('Admin') --}}
                            <button class="btn btn-sm btn-neon-green" data-bs-toggle="modal"
                                data-bs-target="#createEmpModal">+ Add Employee</button>
                            {{-- @endrole --}}
                        </div>
                    </div>
                    <div id="empWrap" class="card-body p-0">
                        <div class="skeleton skeleton-table"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Create Department --}}
    <div class="modal fade" id="createDeptModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form id="createDeptForm" class="modal-content hud-modal" method="POST"
                action="{{ route('departments.store') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Create Department</h5>
                </div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label class="form-label">Name</label>
                        <input name="name" class="form-control hud-input" required>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Code</label>
                        <input name="code" class="form-control hud-input" placeholder="(optional)">
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Parent</label>
                        <select name="parent_id" id="deptParentSelect" class="form-select hud-input">
                            <option value="">—</option>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label class="form-label">Color</label>
                        <input name="color_code" class="form-control hud-input" placeholder="#0c7a7a">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-outline-inverse" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-neon">Create</button>
                </div>
            </form>
        </div>
    </div>

    {{-- Create Employee --}}
    <div class="modal fade" id="createEmpModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form id="createEmpForm" class="modal-content hud-modal" method="POST" action="{{ route('employees.store') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Create Employee</h5>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="status" value="active">
                    <div class="mb-2"><label class="form-label">Employee Code</label>
                        <input name="employee_code" class="form-control hud-input" required>
                    </div>
                    <div class="mb-2"><label class="form-label">Branch ID</label>
                        <input name="branch_id" type="number" class="form-control hud-input" required>
                    </div>
                    <div class="mb-2"><label class="form-label">Department</label>
                        <select name="department_id" id="empDeptSelect" class="form-select hud-input" required></select>
                    </div>
                    <div class="mb-2"><label class="form-label">First name</label>
                        <input name="first_name" class="form-control hud-input" required>
                    </div>
                    <div class="mb-2"><label class="form-label">Last name</label>
                        <input name="last_name" class="form-control hud-input" required>
                    </div>
                    <div class="mb-2"><label class="form-label">User (optional)</label>
                        <input name="user_id" type="number" class="form-control hud-input" placeholder="User ID">
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-outline-inverse" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-neon-green">Create</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('css')
    <style>
        :root {
            /* Neon tokens (متناسقة مع باقي الصفحات) */
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        .hud-card {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: #28292b69; */
        }

        .hud-head {
            border-bottom: 1px dashed var(--border);
            /* background: linear-gradient(180deg, rgba(0, 224, 255, .08), transparent); */
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .btn-neon {
            /* background: linear-gradient(90deg, rgba(0, 224, 255, .18), rgba(255, 95, 255, .18)); */
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            border-radius: 10px;
            padding: .45rem .8rem;
            box-shadow: var(--glow);
        }

        .btn-neon:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .btn-neon-green {
            @apply .btn-neon;
        }

        /* لو Tailwind مش موجود: كرر السطرين فوق */
        .btn-outline-inverse {
            border: 1px solid var(--border-2);
            color: #e9f6ff;
            border-radius: 10px;
        }

        .btn-outline-inverse:hover {
            background: rgba(0, 224, 255, .06);
        }

        .hud-input {
            background: rgba(0, 224, 255, .06);
            border: 1px solid var(--border);
            color: #e3eeff;
            border-radius: 10px;
        }

        .hud-input:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
            color: #fff;
        }

        /* Tree */
        #deptTree {
            scrollbar-width: thin;
        }

        .tree-node .tree-line {
            display: flex;
            align-items: center;
            gap: .5rem;
            padding: .28rem .4rem;
            border-radius: 10px;
            transition: background .2s, transform .1s;
        }

        .tree-node .tree-line:hover {
            background: rgba(0, 224, 255, .06);
            transform: translateX(1px);
        }

        .tree-toggle {
            border: none;
            background: transparent;
            color: #9aa4af;
            font-size: .9rem;
            width: 1.25rem;
        }

        .tree-name {
            text-decoration: none;
            color: #cde4e4;
        }

        .tree-name.active {
            color: var(--neon-2);
            font-weight: 700;
            text-shadow: 0 0 10px rgba(0, 224, 255, .3);
        }

        .badge.bg-dark-subtle {
            background: rgba(0, 224, 255, .06) !important;
            border: 1px solid var(--border-2);
            color: #cfe7ff;
            border-radius: 999px;
        }

        /* Skeletons */
        .skeleton-lines,
        .skeleton-table {
            /* background: linear-gradient(90deg, #1f2937 25%, #2b3645 37%, #1f2937 63%); */
            background-size: 400% 100%;
            animation: shimmer 1.2s infinite;
            border-radius: 12px;
        }

        .skeleton-lines {
            height: 80px;
        }

        .skeleton-table {
            height: 160px;
        }

        @keyframes shimmer {
            0% {
                background-position: 100% 0
            }

            100% {
                background-position: -100% 0
            }
        }

        /* Table HUD */
        #empWrap .table {
            margin: 0;
            color: #dfe7ff;
        }

        #empWrap thead th {
            border-top: 0;
            background: rgba(0, 224, 255, .06);
            color: #cfe7ff;
            text-transform: uppercase;
            font-size: .75rem;
            letter-spacing: .4px;
        }

        #empWrap tbody td {
            border-top: 1px solid var(--border);
            vertical-align: middle;
            background: rgba(0, 224, 255, .06);
        }

        #empWrap .badge.bg-secondary {
            background: rgba(0, 224, 255, .06);
            border: 1px solid var(--border-2);
            color: #cfe7ff;
        }

        table #deptTree {
            background: rgba(0, 224, 255, .06);

        }

        /* Toasts with progress */


        @keyframes toastProg {
            from {
                transform: scaleX(1);
                transform-origin: left
            }

            to {
                transform: scaleX(0);
                transform-origin: left
            }
        }
    </style>
@endpush

@push('js')
    {{-- نفس سكريبتك الأصلي 100% معاه — لم أغيّر الـ logic؛ فقط الواجهة --}}
    <script>
        /* ————— سكريبت الصفحة كما أرسلته ————— */
        (() => {
            const $tree = document.getElementById('deptTree');
            const $emp = document.getElementById('empWrap');
            const $treeSearch = document.getElementById('treeSearch');
            const $empSearch = document.getElementById('empSearch');

            const ROUTES = {
                tree: @json(route('org.tree')),
                employees: @json(route('org.dept.employees', ['department' => '__ID__'])),
                showEmp: @json(route('employees.show', ['employee' => '__ID__'])),
                updateEmp: @json(route('employees.update', ['employee' => '__ID__'])),
                deleteEmp: @json(route('employees.destroy', ['employee' => '__ID__'])),
                createDept: @json(route('departments.store')),
                createEmp: @json(route('employees.store')),
            };
            const CSRF = document.querySelector('meta[name="csrf-token"]')?.content;

            let TREE = [];
            let SELECTED_ID = Number(new URLSearchParams(window.location.search).get('department_id')) || null;
            let EMP_PAGE = 1,
                EMP_QUERY = '';

            function showToast({
                title = 'Notice',
                body = '',
                variant = 'info',
                delay = 4000
            } = {}) {
                const meta = {
                    success: {
                        emoji: '😊',
                        label: 'Success'
                    },
                    error: {
                        emoji: '😡',
                        label: 'Error'
                    },
                    warning: {
                        emoji: '⚠️',
                        label: 'Warning'
                    },
                    info: {
                        emoji: '💡',
                        label: 'Info'
                    }
                } [variant] || {
                    emoji: '💬',
                    label: 'Notice'
                };
                const container = document.getElementById('toastContainer');
                const id = 't' + Math.random().toString(36).slice(2);
                const el = document.createElement('div');
                el.className = `toast align-items-center glass ${variant}`;
                el.id = id;
                el.setAttribute('role', 'alert');
                el.setAttribute('aria-live', 'assertive');
                el.setAttribute('aria-atomic', 'true');
                el.innerHTML =
                    `<div class="toast-header"><div class="toast-avatar me-2">${meta.emoji}</div><strong class="me-auto">${title||meta.label}</strong><small class="text-muted">now</small><button type="button" class="btn-close ms-2 mb-1" data-bs-dismiss="toast"></button></div><div class="toast-body">${body}</div><div class="toast-progress"></div>`;
                el.style.setProperty('--delayms', `${delay}ms`);
                container.appendChild(el);
                const t = new bootstrap.Toast(el, {
                    delay,
                    autohide: true
                });
                t.show();
                el.addEventListener('hidden.bs.toast', () => el.remove());
            }

            function parseErrorPayload(status, payload, fallbackText = 'Something went wrong') {
                let message = fallbackText,
                    errors = null;
                if (payload && typeof payload === 'object') {
                    if (payload.message) message = payload.message;
                    if (payload.errors && typeof payload.errors === 'object') {
                        errors = payload.errors
                    }
                } else if (typeof payload === 'string' && payload.trim()) {
                    message = payload
                }
                if (!payload || !payload.message) {
                    if (status === 419) message = 'Session expired, please refresh and try again.';
                    if (status === 401) message = 'Unauthorized.';
                    if (status === 403) message = 'Forbidden.';
                    if (status === 404) message = 'Not found.';
                    if (status === 409) message = 'Conflict.';
                    if (status === 429) message = 'Too many requests.';
                    if (status >= 500) message = 'Server error, please try again later.'
                }
                return {
                    message,
                    errors
                }
            }

            function clearFormErrors(form) {
                form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
                form.querySelectorAll('.invalid-feedback.dynamic').forEach(el => el.remove())
            }

            function setFormErrors(form, fieldErrors) {
                Object.entries(fieldErrors || {}).forEach(([field, msgs]) => {
                    const input = form.querySelector(`[name="${field}"]`);
                    if (!input) return;
                    input.classList.add('is-invalid');
                    const fb = document.createElement('div');
                    fb.className = 'invalid-feedback dynamic';
                    fb.textContent = Array.isArray(msgs) ? msgs.join(' ') : String(msgs);
                    input.insertAdjacentElement('afterend', fb)
                });
                const firstInvalid = form.querySelector('.is-invalid');
                if (firstInvalid) firstInvalid.focus({
                    preventScroll: false
                })
            }
            async function apiFetch(url, {
                method = 'GET',
                headers = {},
                body = null
            } = {}) {
                const baseHeaders = {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                    ...headers
                };
                const res = await fetch(url, {
                    method,
                    headers: baseHeaders,
                    body
                });
                let data = null;
                const ct = res.headers.get('content-type') || '';
                try {
                    data = ct.includes('application/json') ? await res.json() : await res.text()
                } catch (_) {}
                if (!res.ok) {
                    const {
                        message,
                        errors
                    } = parseErrorPayload(res.status, data);
                    const err = new Error(message);
                    err.status = res.status;
                    err.errors = errors;
                    err.raw = data;
                    throw err
                }
                return data
            }
            const h = (tag, attrs = {}, ...children) => {
                const el = document.createElement(tag);
                for (const [k, v] of Object.entries(attrs || {})) {
                    if (k === 'class') el.className = v;
                    else if (k === 'style') Object.assign(el.style, v);
                    else if (k.startsWith('on') && typeof v === 'function') el.addEventListener(k.slice(2), v);
                    else el.setAttribute(k, v)
                }
                children.flat().forEach(c => el.append(typeof c === 'string' ? document.createTextNode(c) : c));
                return el
            };
            const badge = t => h('span', {
                class: 'badge bg-dark-subtle text-light ms-2'
            }, String(t));
            const flatten = (nodes, depth = 0, acc = []) => {
                nodes.forEach(n => {
                    acc.push({
                        id: n.id,
                        name: n.name,
                        depth
                    });
                    flatten(n.children || [], depth + 1, acc)
                });
                return acc
            };

            function renderTree() {
                const $wrap = $tree;
                $wrap.innerHTML = '';
                const f = ($treeSearch.value || '').toLowerCase();
                const match = n => n.name.toLowerCase().includes(f) || (n.children || []).some(match);

                function nodeEl(n, level = 0) {
                    const wrap = h('div', {
                        class: 'tree-node',
                        style: {
                            paddingLeft: (level * 14) + 'px'
                        }
                    });
                    const line = h('div', {
                        class: 'tree-line'
                    });
                    let open = level < 1;
                    const toggle = h('button', {
                        class: 'tree-toggle',
                        'aria-label': 'toggle',
                        onclick: (e) => {
                            e.preventDefault();
                            open = !open;
                            toggle.textContent = open ? '▾' : '▸';
                            childrenWrap.style.display = open ? 'block' : 'none';
                        }
                    }, open ? '▾' : '▸');
                    const name = h('a', {
                        href: '#',
                        class: 'tree-name' + (SELECTED_ID === n.id ? ' active' : ''),
                        onclick: (e) => {
                            e.preventDefault();
                            selectDept(n.id);
                        }
                    }, n.name);
                    const childrenWrap = h('div', {
                        class: 'tree-children',
                        style: {
                            display: open ? 'block' : 'none'
                        }
                    }, ...(n.children || []).map(c => nodeEl(c, level + 1)));
                    line.append(toggle, name, badge(n.employees_count));
                    wrap.append(line, childrenWrap);
                    return wrap;
                }
                const roots = f ? TREE.filter(match) : TREE;
                if (!roots.length) {
                    $wrap.append(h('div', {
                        class: 'text-muted small'
                    }, 'No departments'));
                    return
                }
                roots.forEach(r => $wrap.append(nodeEl(r)));
            }

            async function loadTree() {
                $tree.innerHTML = '<div class="skeleton skeleton-lines"></div>';
                try {
                    const json = await apiFetch(ROUTES.tree);
                    TREE = json.roots || [];
                    if (!SELECTED_ID) SELECTED_ID = TREE[0]?.id || null;
                    renderTree();
                    populateDeptSelects();
                    if (SELECTED_ID) loadEmployees(SELECTED_ID);
                } catch (e) {
                    $tree.innerHTML = '';
                    showToast({
                        title: 'Tree Error',
                        body: e.message,
                        variant: 'error'
                    });
                }
            }

            async function loadEmployees(deptId, page = 1) {
                SELECTED_ID = deptId;
                EMP_PAGE = page;
                $emp.innerHTML = '<div class="skeleton skeleton-table"></div>';
                let url = ROUTES.employees.replace('__ID__', String(deptId));
                const params = new URLSearchParams();
                params.set('page', page);
                if (EMP_QUERY) params.set('q', EMP_QUERY);
                url += (url.includes('?') ? '&' : '?') + params.toString();
                try {
                    const json = await apiFetch(url);
                    const tbl = h('table', {
                        class: 'table table-striped align-middle mb-0'
                    });
                    tbl.innerHTML =
                        `<thead><tr><th>#</th><th>Name</th><th>User</th><th>Dept</th><th>Status</th><th class="text-end">Actions</th></tr></thead><tbody></tbody>`;
                    const tbody = tbl.querySelector('tbody');
                    if (!json.data?.length) {
                        tbody.append(h('tr', {}, h('td', {
                            colspan: 6,
                            class: 'text-center text-muted py-4'
                        }, 'No employees')));
                    } else {
                        json.data.forEach(e => {
                            const editBtn = h('a', {
                                href: '#',
                                class: 'btn btn-sm btn-outline-primary me-1',
                                onclick: (ev) => {
                                    ev.preventDefault();
                                    openEditModal(e.id);
                                }
                            }, 'Edit');
                            const delBtn = h('a', {
                                href: '#',
                                class: 'btn btn-sm btn-outline-danger',
                                onclick: (ev) => {
                                    ev.preventDefault();
                                    confirmDelete(e.id);
                                }
                            }, 'Delete');
                            const tr = h('tr', {},
                                h('td', {}, String(e.id)),
                                h('td', {}, e.name ?? '—'),
                                h('td', {}, e.user_email ?? '—'),
                                h('td', {}, e.dept ?? '—'),
                                h('td', {}, h('span', {
                                    class: 'badge bg-secondary'
                                }, e.status)),
                                h('td', {
                                    class: 'text-end'
                                }, editBtn, delBtn)
                            );
                            tbody.append(tr);
                        });
                    }
                    const m = json.meta || {};
                    const pager = h('div', {
                            class: 'd-flex justify-content-between align-items-center p-2 border-top',
                            style: {
                                borderColor: 'var(--border)'
                            }
                        },
                        h('div', {
                            class: 'small text-muted'
                        }, `Total: ${m.total??0}`),
                        h('div', {},
                            h('button', {
                                class: 'btn btn-sm btn-outline-inverse me-1',
                                disabled: (m.current_page ?? 1) <= 1,
                                onclick: () => loadEmployees(SELECTED_ID, EMP_PAGE - 1)
                            }, '‹ Prev'),
                            h('span', {
                                class: 'small mx-2'
                            }, `Page ${m.current_page??1} / ${m.last_page??1}`),
                            h('button', {
                                class: 'btn btn-sm btn-outline-inverse ms-1',
                                disabled: (m.current_page ?? 1) >= (m.last_page ?? 1),
                                onclick: () => loadEmployees(SELECTED_ID, EMP_PAGE + 1)
                            }, 'Next ›')
                        )
                    );
                    $emp.innerHTML = '';
                    $emp.append(tbl, pager);
                    renderTree();
                    const u = new URL(window.location.href);
                    u.searchParams.set('department_id', String(SELECTED_ID));
                    history.replaceState(null, '', u);
                    const sel = document.getElementById('empDeptSelect');
                    if (sel) sel.value = String(SELECTED_ID);
                } catch (e) {
                    $emp.innerHTML = '';
                    showToast({
                        title: 'Employees Error',
                        body: e.message,
                        variant: 'error'
                    });
                }
            }

            function selectDept(id) {
                loadEmployees(id, 1);
            }

            const MODAL_ID = 'ajaxEditEmpModal';

            function ensureEditModal() {
                if (document.getElementById(MODAL_ID)) return;
                document.body.insertAdjacentHTML('beforeend', `
    <div class="modal fade" id="${MODAL_ID}" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog">
        <form class="modal-content hud-modal" id="${MODAL_ID}Form">
          <div class="modal-header"><h5 class="modal-title">Edit Employee</h5></div>
          <div class="modal-body">
            <input type="hidden" name="_method" value="PATCH">
            <div class="mb-2"><label class="form-label">First name</label><input name="first_name" class="form-control hud-input" required></div>
            <div class="mb-2"><label class="form-label">Last name</label><input name="last_name" class="form-control hud-input" required></div>
            <div class="mb-2"><label class="form-label">Department</label><select name="department_id" class="form-select hud-input" id="editDeptSelect" required></select></div>
            <div class="mb-2"><label class="form-label">Status</label>
              <select name="status" class="form-select hud-input">
                <option value="active">active</option><option value="inactive">inactive</option><option value="on_leave">on_leave</option>
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-inverse" data-bs-dismiss="modal">Close</button>
            <button class="btn btn-neon">Save</button>
          </div>
        </form>
      </div>
    </div>`);
            }

            function fillDeptSelect(selectEl, selectedId) {
                const all = (function flat(nodes, d = 0, acc = []) {
                    nodes.forEach(n => {
                        acc.push({
                            id: n.id,
                            name: n.name,
                            depth: d
                        });
                        (n.children || []).length && flat(n.children, d + 1, acc)
                    });
                    return acc
                })(TREE);
                selectEl.innerHTML = '';
                all.forEach(x => {
                    const o = document.createElement('option');
                    o.value = x.id;
                    o.textContent = '— '.repeat(x.depth) + x.name;
                    selectEl.appendChild(o)
                });
                if (selectedId) selectEl.value = String(selectedId);
            }
            async function openEditModal(empId) {
                ensureEditModal();
                const modalEl = document.getElementById(MODAL_ID);
                const form = document.getElementById(MODAL_ID + 'Form');
                let e;
                try {
                    const res = await apiFetch(ROUTES.showEmp.replace('__ID__', String(empId)));
                    e = res.data;
                } catch (err) {
                    showToast({
                        title: 'Load Failed',
                        body: err.message,
                        variant: 'error'
                    });
                    return;
                }
                form.action = ROUTES.updateEmp.replace('__ID__', String(e.id));
                form.querySelector('[name=first_name]').value = e.first_name ?? '';
                form.querySelector('[name=last_name]').value = e.last_name ?? '';
                form.querySelector('[name=status]').value = e.status ?? 'active';
                fillDeptSelect(document.getElementById('editDeptSelect'), e.department_id ?? SELECTED_ID);
                form.onsubmit = async (ev) => {
                    ev.preventDefault();
                    clearFormErrors(form);
                    try {
                        const fd = new FormData(form);
                        await apiFetch(form.action, {
                            method: 'POST',
                            headers: {
                                'X-CSRF-TOKEN': CSRF
                            },
                            body: fd
                        });
                        bootstrap.Modal.getInstance(modalEl)?.hide();
                        showToast({
                            title: 'Updated',
                            body: 'Employee updated successfully.',
                            variant: 'success'
                        });
                        loadEmployees(SELECTED_ID, EMP_PAGE);
                    } catch (err) {
                        if (err.errors) setFormErrors(form, err.errors);
                        showToast({
                            title: 'Update Failed',
                            body: err.message,
                            variant: 'error'
                        })
                    }
                };
                new bootstrap.Modal(modalEl).show();
            }
            async function confirmDelete(id) {
                if (!confirm('Delete this employee?')) return;
                try {
                    const url = ROUTES.deleteEmp.replace('__ID__', String(id));
                    const fd = new FormData();
                    fd.append('_method', 'DELETE');
                    await apiFetch(url, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': CSRF
                        },
                        body: fd
                    });
                    showToast({
                        title: 'Deleted',
                        body: 'Employee deleted.',
                        variant: 'success'
                    });
                    loadEmployees(SELECTED_ID, EMP_PAGE);
                } catch (err) {
                    showToast({
                        title: 'Delete Failed',
                        body: err.message,
                        variant: 'error'
                    })
                }
            }

            function populateDeptSelects() {
                const flat = (function f(nodes, d = 0, acc = []) {
                    nodes.forEach(n => {
                        acc.push({
                            id: n.id,
                            name: n.name,
                            depth: d
                        });
                        f(n.children || [], d + 1, acc)
                    });
                    return acc
                })(TREE);
                const parentSel = document.getElementById('deptParentSelect');
                const empSel = document.getElementById('empDeptSelect');
                const makeOpt = d => {
                    const opt = document.createElement('option');
                    opt.value = d.id;
                    opt.textContent = '— '.repeat(d.depth) + d.name;
                    return opt
                };
                if (parentSel) {
                    parentSel.innerHTML = '<option value="">—</option>';
                    flat.forEach(d => parentSel.append(makeOpt(d)));
                }
                if (empSel) {
                    empSel.innerHTML = '';
                    flat.forEach(d => empSel.append(makeOpt(d)));
                    if (SELECTED_ID) empSel.value = String(SELECTED_ID);
                }
            }

            document.getElementById('createDeptForm')?.addEventListener('submit', async (e) => {
                e.preventDefault();
                const form = e.currentTarget;
                clearFormErrors(form);
                try {
                    const fd = new FormData(form);
                    const data = await apiFetch(ROUTES.createDept, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': CSRF
                        },
                        body: fd
                    });
                    bootstrap.Modal.getInstance(document.getElementById('createDeptModal'))?.hide();
                    form.reset();
                    await loadTree();
                    showToast({
                        title: 'Success',
                        body: data?.message ?? 'Department created.',
                        variant: 'success'
                    });
                } catch (err) {
                    if (err.errors) setFormErrors(form, err.errors);
                    showToast({
                        title: 'Create Department Failed',
                        body: err.message,
                        variant: 'error'
                    })
                }
            });
            document.getElementById('createEmpForm')?.addEventListener('submit', async (e) => {
                e.preventDefault();
                const form = e.currentTarget;
                clearFormErrors(form);
                try {
                    const fd = new FormData(form);
                    const data = await apiFetch(ROUTES.createEmp, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': CSRF
                        },
                        body: fd
                    });
                    bootstrap.Modal.getInstance(document.getElementById('createEmpModal'))?.hide();
                    form.reset();
                    await loadEmployees(SELECTED_ID, 1);
                    showToast({
                        title: 'Success',
                        body: data?.message ?? 'Employee created.',
                        variant: 'success'
                    });
                } catch (err) {
                    if (err.errors) setFormErrors(form, err.errors);
                    showToast({
                        title: 'Create Employee Failed',
                        body: err.message,
                        variant: 'error'
                    })
                }
            });

            $treeSearch?.addEventListener('input', () => renderTree());
            let empTimer;
            $empSearch?.addEventListener('input', () => {
                clearTimeout(empTimer);
                empTimer = setTimeout(() => {
                    EMP_QUERY = $empSearch.value.trim();
                    loadEmployees(SELECTED_ID, 1);
                }, 300)
            });

            loadTree();
        })();
    </script>
@endpush
