 @php
    $children = $all->where('parent_id', $node->id);
    $active = isset($selectedId) && (int)$selectedId === (int)$node->id;
  @endphp
<li class="mb-1">
  <a href="{{ route('org.index', ['department_id' => $node->id]) }}"
     class="{{ $selectedId==$node->id ? 'fw-bold text-primary' : '' }}">
     {{ $node->name }}
     <span class="badge bg-light text-dark">{{ $node->employees_count ?? 0 }}</span>
  </a>


  @if($children->count())
    <ul class="ms-3 mt-1">
      @foreach($children as $child)
        @include('pages.departments-teams.partials.dept-node', ['node'=>$child, 'selectedId'=>$selectedId, 'all'=>$all])
      @endforeach
    </ul>
  @endif
</li>
