@extends('layout.default')
@section('title', 'Department Details')

@section('content')
    <!-- BEGIN breadcrumb -->
    <ol class="breadcrumb float-xl-end">
        <li class="breadcrumb-item"><a href="javascript:;">Home</a></li>
        <li class="breadcrumb-item"><a href="{{ route('departments.index') }}">Departments</a></li>
        <li class="breadcrumb-item active">{{ $department->name }}</li>
    </ol>
    <!-- END breadcrumb -->

    <!-- BEGIN page-header -->
    <h1 class="page-header">{{ $department->name }} <small>Department Details</small></h1>
    <!-- END page-header -->

    <!-- BEGIN row -->
    <div class="row">
        <!-- Department Info -->
        <div class="col-xl-4">
            <div class="panel panel-inverse">
                <div class="panel-heading">
                    <h4 class="panel-title">Department Information</h4>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table">
                            <tr>
                                <td><strong>Name:</strong></td>
                                <td>{{ $department->name }}</td>
                            </tr>
                            <tr>
                                <td><strong>Code:</strong></td>
                                <td>{{ $department->code }}</td>
                            </tr>
                            <tr>
                                <td><strong>Color:</strong></td>
                                <td>
                                    <span class="badge" style="background-color: {{ $department->color_code }}">
                                        {{ $department->color_code }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Parent Department:</strong></td>
                                <td>{{ $department->parent ? $department->parent->name : 'None' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Employees Count:</strong></td>
                                <td>{{ $department->employees->count() }}</td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <span class="badge bg-{{ $department->is_active ? 'success' : 'danger' }}">
                                        {{ $department->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Department Employees -->
        <div class="col-xl-8">
            <div class="panel panel-inverse">
                <div class="panel-heading">
                    <h4 class="panel-title">Employees ({{ $department->employees->count() }})</h4>
                </div>
                <div class="panel-body">
                    @if ($department->employees->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Employee Code</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Hire Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($department->employees as $employee)
                                        <tr>
                                            <td>{{ $employee->employee_code }}</td>
                                            <td>{{ $employee->full_name }}</td>
                                            <td>{{ $employee->user->email ?? 'N/A' }}</td>
                                            <td>
                                                <span
                                                    class="badge bg-{{ $employee->status === 'active' ? 'success' : 'danger' }}">
                                                    {{ ucfirst($employee->status) }}
                                                </span>
                                            </td>
                                            <td>{{ $employee->hire_date?->format('Y-m-d') ?? 'N/A' }}</td>
                                            <td>
                                                <button class="btn btn-xs btn-info"
                                                    onclick="showEmployeeAttendance('{{ $employee->employee_code }}')"
                                                    title="View Attendance">
                                                    <i class="fa fa-clock"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            No employees found in this department.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Sub Departments -->
    @if ($department->children->count() > 0)
        <div class="row">
            <div class="col-12">
                <div class="panel panel-inverse">
                    <div class="panel-heading">
                        <h4 class="panel-title">Sub Departments ({{ $department->children->count() }})</h4>
                    </div>
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Code</th>
                                        <th>Color</th>
                                        <th>Employees Count</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($department->children as $subDept)
                                        <tr>
                                            <td>{{ $subDept->name }}</td>
                                            <td>{{ $subDept->code }}</td>
                                            <td>
                                                <span class="badge" style="background-color: {{ $subDept->color_code }}">
                                                    {{ $subDept->color_code }}
                                                </span>
                                            </td>
                                            <td>{{ $subDept->employees->count() }}</td>
                                            <td>
                                                <span class="badge bg-{{ $subDept->is_active ? 'success' : 'danger' }}">
                                                    {{ $subDept->is_active ? 'Active' : 'Inactive' }}
                                                </span>
                                            </td>
                                            <td>
                                                <a href="{{ route('departments.show', $subDept->id) }}"
                                                    class="btn btn-xs btn-primary">
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- END row -->

    <!-- Employee Attendance Modal -->
    <div class="modal fade" id="modalEmployeeAttendance" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="employeeAttendanceModalLabel">Employee Attendance</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="employeeAttendanceDate" class="form-label">Select Date</label>
                        <input type="date" class="form-control" id="employeeAttendanceDate" value="{{ date('Y-m-d') }}">
                    </div>
                    <div id="employeeAttendanceModalBody">
                        <div class="text-center">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        function showEmployeeAttendance(employeeCode) {
            const modal = new bootstrap.Modal(document.getElementById('modalEmployeeAttendance'));
            modal.show();

            document.getElementById('employeeAttendanceDate').setAttribute('data-employee-code', employeeCode);
            loadEmployeeAttendance(employeeCode, document.getElementById('employeeAttendanceDate').value);
        }

        function loadEmployeeAttendance(employeeCode, date) {
            document.getElementById('employeeAttendanceModalBody').innerHTML = `
        <div class="text-center">
            <div class="spinner-border" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    `;

            fetch(`/employees/${employeeCode}/attendance?date=${date}`)
                .then(response => response.json())
                .then(data => {
                    if (!data.success) {
                        document.getElementById('employeeAttendanceModalBody').innerHTML =
                            `<div class="alert alert-danger">${data.message || 'Error loading attendance data.'}</div>`;
                        return;
                    }

                    let html = `
                <div class="row mb-3">
                    <div class="col-md-6">
                        <h6>Employee: ${data.employee.name}</h6>
                        <p class="text-muted">Code: ${data.employee.code} | Department: ${data.employee.department}</p>
                    </div>
                    <div class="col-md-6">
                        <div class="alert alert-info">
                            <strong>Summary:</strong><br>
                            Total Hours: ${data.summary.total_hours}<br>
                            Check-ins: ${data.summary.check_ins} | Check-outs: ${data.summary.check_outs}<br>
                            Status: <span class="badge bg-${data.summary.status === 'Complete' ? 'success' : 'warning'}">${data.summary.status}</span>
                        </div>
                    </div>
                </div>
            `;

                    if (data.attendance.length === 0) {
                        html += '<div class="alert alert-info">No attendance records found for this date.</div>';
                    } else {
                        html += `
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Check In</th>
                                    <th>Check Out</th>
                                    <th>Duration</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                `;

                        data.attendance.forEach(record => {
                            html += `
                        <tr>
                            <td>${record.check_in}</td>
                            <td>${record.check_out || '-'}</td>
                            <td>${record.duration || '-'}</td>
                            <td>
                                <span class="badge bg-${record.status === 'Complete' ? 'success' : 'warning'}">
                                    ${record.status}
                                </span>
                            </td>
                        </tr>
                    `;
                        });

                        html += '</tbody></table></div>';
                    }

                    document.getElementById('employeeAttendanceModalBody').innerHTML = html;
                })
                .catch(error => {
                    document.getElementById('employeeAttendanceModalBody').innerHTML =
                        '<div class="alert alert-danger">Error loading employee attendance data.</div>';
                    console.error('Error:', error);
                });
        }

        // Handle date changes in employee attendance modal
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('employeeAttendanceDate').addEventListener('change', function() {
                const employeeCode = this.getAttribute('data-employee-code');
                if (employeeCode) {
                    loadEmployeeAttendance(employeeCode, this.value);
                }
            });
        });
    </script>
@endpush
