@extends('layout.default', [
	'appClass' => 'app-content-full-height',
	'appContentClass' => 'p-3'
])

@section('title', 'Inbox (20+)')

@section('content')
	<!-- BEGIN card -->
	<div class="card h-100">
		<!-- BEGIN mailbox -->
		<div class="mailbox">
			<!-- BEGIN mailbox-toolbar -->
			<div class="mailbox-toolbar">
				<div class="mailbox-toolbar-item"><span class="mailbox-toolbar-text">Mailboxes</span></div>
				<div class="mailbox-toolbar-item"><a href="/email/inbox" class="mailbox-toolbar-link active">Inbox</a></div>
				<div class="mailbox-toolbar-item"><a href="/email/inbox" class="mailbox-toolbar-link">Sent</a></div>
				<div class="mailbox-toolbar-item"><a href="/email/inbox" class="mailbox-toolbar-link">Drafts (1)</a></div>
				<div class="mailbox-toolbar-item"><a href="/email/inbox" class="mailbox-toolbar-link">Junk</a></div>
				<div class="mailbox-toolbar-item"><a href="/email/compose" class="mailbox-toolbar-link text-inverse bg-inverse bg-opacity-15">New Message <i class="fa fa-pen fs-12px ms-1"></i></a></div>
			</div>
			<!-- END mailbox-toolbar -->
			<!-- BEGIN mailbox-body -->
			<div class="mailbox-body d-flex">
                <div class="mailbox-sidebar" data-scrollbar="true" data-height="100%">
                    <div class="mailbox-list">
                        @foreach($messages as $msg)
                        {{-- @dd($messages); --}}
                            {{-- <div class="mailbox-list-item {{ $msg->isSeen() ? '' : 'unread' }} {{ $msg->hasAttachments() ? 'has-attachment' : '' }}"> --}}
                            <div class="mailbox-checkbox">
                                <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="" />
                                </div>
                            </div>
                            <div class="mailbox-message">
                                {{-- <a href="{{ route('email.detail', $msg->getUid()) }}" class="mailbox-list-item-link"> --}}
                                <div class="mailbox-sender">
                                    <span class="mailbox-sender-name">{{ $msg->getFrom()[0]->mail }}</span>
                                    {{-- <span class="mailbox-time">{{ $msg->getDate()->format('d M Y H:i') }}</span> --}}
                                </div>
                                <div class="mailbox-title">{{ Str::limit($msg->getSubject(), 50) }}</div>
                                <div class="mailbox-desc">{{ Str::limit($msg->getTextBody() ?: $msg->getHTMLBody(), 80) }}</div>
                                </a>
                            </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                                 <!-- Optionally: preview pane here -->
            </div>
                                            <!-- END mailbox-body -->
		</div>
		<!-- END mailbox -->

		<!-- BEGIN card-arrow -->
		<div class="card-arrow">
			<div class="card-arrow-top-left"></div>
			<div class="card-arrow-top-right"></div>
			<div class="card-arrow-bottom-left"></div>
			<div class="card-arrow-bottom-right"></div>
		</div>
		<!-- END card-arrow -->
	</div>
	<!-- END card -->
@endsection
