@extends('layout.default')

@section('title', 'My Attendance')

@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-dt@1.13.8/css/jquery.dataTables.min.css">
    {{-- Buttons + ColVis (لضمان ظهور/عمل قائمة الأعمدة) --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-buttons-dt@2.4.2/css/buttons.dataTables.min.css">

    <style>
        :root {
            --card-bg: #0b1020;
            --body-bg: #070b18;
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --glow: 0 0 12px rgba(42, 252, 152, .4), 0 0 30px rgba(0, 224, 255, .2);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .2) inset;
        }

        .att-wrap {
            display: grid;
            gap: 1rem;
        }

        @media(min-width:992px) {
            .att-wrap {
                grid-template-columns: 1.25fr .9fr;
            }
        }

        .card-n {
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
            border-radius: 14px;
            padding: 14px;
            border: 1px solid rgba(0, 224, 255, .12);
            box-shadow: var(--glow);
        }

        .neon-title {
            font-weight: 700;
            letter-spacing: .5px;
            margin: 0 0 10px;
            text-shadow: 0 0 12px rgba(0, 224, 255, .35);
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }

        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid rgba(0, 224, 255, .35);
            padding: .55rem 1rem;
            border-radius: 10px;
            backdrop-filter: blur(4px);
            transition: .2s ease;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn-danger {
            border-color: rgba(255, 95, 95, .45) !important;
        }

        .chip {
            display: inline-flex;
            align-items: center;
            gap: .4rem;
            padding: .25rem .55rem;
            border-radius: 999px;
            font-size: .8rem;
            color: #bcd6ff;
            background: rgba(0, 224, 255, .08);
            border: 1px solid rgba(0, 224, 255, .25);
        }

        #calendar {
            min-height: 600px;
            border-radius: 12px;
            overflow: hidden;
            border: 1px solid rgba(0, 224, 255, .15);
        }

        table.dataTable {
            color: #dce7ff;
        }

        table.dataTable thead th {
            color: #cfe7ff;
            background: rgba(0, 224, 255, .08);
            border-bottom: 1px solid rgba(0, 224, 255, .25);
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        table.dataTable tbody td {
            border-color: rgba(0, 224, 255, .08);
        }

        .badge {
            border-radius: 999px;
            padding: .35rem .6rem;
            font-weight: 600;
        }

        .bg-success {
            background: linear-gradient(90deg, rgba(42, 252, 152, .25), rgba(0, 224, 255, .2));
            color: #dfffea;
            border: 1px solid rgba(42, 252, 152, .45);
        }

        .bg-warning {
            background: linear-gradient(90deg, rgba(255, 217, 0, .18), rgba(255, 127, 39, .18));
            color: #fff0c9;
            border: 1px solid rgba(255, 217, 0, .35);
        }

        .bg-danger {
            background: linear-gradient(90deg, rgba(255, 95, 95, .22), rgba(255, 0, 130, .15));
            color: #ffe6ea;
            border: 1px solid rgba(255, 95, 95, .45);
        }

        .bg-info {
            background: linear-gradient(90deg, rgba(0, 224, 255, .18), rgba(255, 95, 255, .18));
            color: #e7fbff;
            border: 1px solid rgba(0, 224, 255, .35);
        }

        /* ColVis / Buttons dropdown (dark neon) */
        .dt-button-collection {
            background: linear-gradient(180deg, rgba(15, 22, 40, .98), rgba(8, 12, 24, .98)) !important;
            color: #dfe7ff !important;
            border: 1px solid rgba(0, 224, 255, .25) !important;
            border-radius: 12px !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, .45), 0 0 25px rgba(0, 224, 255, .18) !important;
            backdrop-filter: blur(4px);
            padding: 6px !important;
            z-index: 1055 !important;
            /* فوق أي عناصر تانية */
        }

        /* الأزرار داخل القائمة */
        .dt-button-collection .dt-button,
        .dt-button-collection .buttons-columnVisibility {
            background: transparent !important;
            border: none !important;
            color: #cfe7ff !important;
            text-align: left !important;
            width: 100% !important;
            padding: .55rem .75rem !important;
            border-radius: 10px !important;
            transition: .15s ease;
        }

        /* هور وإكتيف */
        .dt-button-collection .dt-button:hover,
        .dt-button-collection .buttons-columnVisibility:hover {
            /* background: rgba(0, 224, 255, .10) !important; */
            box-shadow: inset 0 0 0 1px rgba(0, 224, 255, .25);
        }

        /* العلامة الصح للأعمدة الظاهرة */
        .dt-button-collection .buttons-columnVisibility::before {
            content: "✓";
            display: inline-block;
            width: 1em;
            margin-right: .5rem;
            color: rgba(42, 252, 152, .9);
            opacity: 0.0;
            transition: .15s ease;
        }

        .dt-button-collection .buttons-columnVisibility.active::before {
            opacity: 1;
        }

        /* النص الداخلي */
        .dt-button-collection .dt-button>span,
        .dt-button-collection .buttons-columnVisibility>span {
            color: #dfe7ff !important;
        }

        div.dt-button-background {
            background: transparent !important;
            /* لغاء التعتيم */
            opacity: 0 !important;
            backdrop-filter: none !important;
            /* خليه تحت القائمة بشوية علشان يفضل يسمع كليك للإغلاق */
            z-index: 1050 !important;
        }

        /* اضمن إن القائمة نفسها فوق الأوڤرلاي */
        div.dt-button-collection {
            z-index: 1051 !important;
        }

        div.dataTables_filter,
        div.dataTables_length {
            display: none !important;
        }

        /* خلفية الـ overlay */
        /* div.dt-button-background {
                                                                                                                    background: rgba(4, 8, 18, .55) !important;
                                                                                                                } */
    </style>
@endpush

@section('content')
    <div class="container py-3">
        <div class="d-flex align-items-center justify-content-between mb-3">
            <h3 class="neon-title">My Attendance</h3>
            <div class="d-flex gap-2">
                <button id="btnCheckIn" class="neon-btn">Check In</button>
                <button id="btnCheckOut" class="neon-btn neon-btn-danger">Check Out</button>
            </div>
        </div>

        {{-- فلاتر الجدول --}}
        @include('pages.home_attandance._filters')

        <div class="att-wrap">
            <div class="card-n">
                <div class="d-flex align-items-center justify-content-between mb-2">
                    <div class="chip">Calendar</div>
                </div>
                <div id="calendar"></div>
            </div>

            <div class="card-n">
                <div class="d-flex align-items-center gap-4">

                    <button id="btnFilter" class="neon-btn">Filter</button>
                    <button id="btnReset" class="neon-btn">Reset</button>
                    <br>
                </div>

                {{-- ترتيب التحميل: jQuery → DataTables → Buttons → assets → تعريف hooks/renders → init --}}
                <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
                <script src="https://cdn.jsdelivr.net/npm/datatables.net@1.13.8/js/jquery.dataTables.min.js"></script>
                <script src="https://cdn.jsdelivr.net/npm/datatables.net-buttons@2.4.2/js/dataTables.buttons.min.js"></script>
                <script src="https://cdn.jsdelivr.net/npm/datatables.net-buttons@2.4.2/js/buttons.html5.min.js"></script>
                <script src="https://cdn.jsdelivr.net/npm/datatables.net-buttons@2.4.2/js/buttons.print.min.js"></script>
                <script src="https://cdn.jsdelivr.net/npm/datatables.net-buttons@2.4.2/js/buttons.colVis.min.js"></script>

                @include('partial.datatable.assets')

                <script>
                    (function() {
                        window.DT = window.DT || {
                            renders: {},
                            hooks: {}
                        };

                        // hook للفلاتر (هيتنده من init)
                        DT.hooks.attFilters = function(d) {
                            d = d || {};
                            d.status = $('#flt_status').val() || '';
                            d.date_from = $('#flt_from').val() || '';
                            d.date_to = $('#flt_to').val() || '';
                            d.branch_id = $('#flt_branch').val() || '';
                            return d;
                        };

                        // render لعمود الحالة
                        DT.renders.att_status = function(data, type, row) {
                            if (row && typeof row.status === 'string') return row.status;
                            if (typeof data === 'string') return data;
                            // احتياطي: لو السيرفر رجّع object فيه status
                            if (data && typeof data.status === 'string') return data.status;
                            return '';
                        };

                        // Compatibility لو الـ assets القديمة بتقرأ من window.*
                        window.attFilters = DT.hooks.attFilters;
                        window.att_status = DT.renders.att_status;
                    })();
                </script>

                {{-- init الموحد: لاحظ titles + تعيين data='status' --}}
                @include('partial.datatable.init', [
                    'id' => 'myAttendanceTable',
                    'ajax' => route('attendance.me.dt'),
                    'columns' => [
                        ['data' => 'work_date', 'title' => 'Date'],
                        ['data' => 'first_in', 'title' => 'In'],
                        ['data' => 'last_out', 'title' => 'Out'],
                        ['data' => 'hours', 'title' => 'Hours'],
                        ['data' => 'sources', 'title' => 'Sources'],
                        // حطينا data='status' علشان يظهر الـ badge حتى لو render ما اشتغلش
                        [
                            'data' => 'status',
                            'title' => 'Status',
                            'orderable' => true,
                            'searchable' => true,
                            'render' => 'att_status',
                        ],
                    ],
                    'order' => [[0, 'desc']],
                    'exportColumns' => [0, 1, 2, 3, 4, 5],
                    'responsive' => 'inline',
                    'filtersHook' => 'attFilters',
                    'thead' => view('pages.home_attandance.thead'),
                    'dom' => 'Brt<"bottom"ip>',
                ])
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script>
        const token = '{{ csrf_token() }}';

        function reloadMyTable() {
            var inst = (window.DT_INSTANCES && window.DT_INSTANCES['myAttendanceTable']) ?
                window.DT_INSTANCES['myAttendanceTable'] :
                ($.fn.dataTable.isDataTable('#myAttendanceTable') ? $('#myAttendanceTable').DataTable() : null);



            if (inst && inst.ajax) {
                try {
                    inst.ajax.reload(null, false);
                } catch (e) {
                    inst.ajax.reload();
                }
            } else if (inst) {
                try {
                    inst.ajax.reload(null, false);
                } catch (e) {
                    inst.ajax.reload();
                }
            } else {
                console.warn('DataTable not ready yet.');
            }
        }

        async function postJSON(url) {
            const res = await fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': token,
                    'Accept': 'application/json'
                }
            });
            if (!res.ok) {
                await window.toast.fromResponse(res, 'Request Failed');
                throw new Error('HTTP ' + res.status);
            }
            return await res.json();
        }

        // ءءءءءءءءءءءءءءءءءءءءءءءءءءء
        //         $('#btnCheckIn').on('click', async () => {
        //             const data = await postJSON('{{ route('attendance.home.checkin') }}');
        //             if (!data.ok) return alert(data.msg || 'Cannot check in');
        //             reloadMyTable();
        //             if (window.calendar) window.calendar.refetchEvents();
        //         });

        //         $('#btnCheckOut').on('click', async () => {
        //             const data = await postJSON('{{ route('attendance.home.checkout') }}');
        //             if (!data.ok) return alert(data.msg || 'Cannot check out');
        //             reloadMyTable();
        //             if (window.calendar) window.calendar.refetchEvents();
        //         });
        // ءءءءءءءءءءءءءءءءءءءءءءء
        $('#btnCheckIn').on('click', async () => {
            try {
                const data = await postJSON('{{ route('attendance.home.checkin') }}');
                if (!data.ok) {
                    window.toast.error('Check In Failed', data.msg || 'Cannot check in');
                    return;
                }
                window.toast.success('Checked In', data.when ? `at <b>${data.when}</b>` : '');
                reloadMyTable();
                if (window.calendar) window.calendar.refetchEvents();
            } catch (e) {
                /* تم إظهار التوست داخل postJSON */
            }
        });

        $('#btnCheckOut').on('click', async () => {
            try {
                const data = await postJSON('{{ route('attendance.home.checkout') }}');
                if (!data.ok) {
                    window.toast.error('Check Out Failed', data.msg || 'Cannot check out');
                    return;
                }
                window.toast.success('Checked Out', data.when ? `at <b>${data.when}</b>` : '');
                reloadMyTable();
                if (window.calendar) window.calendar.refetchEvents();
            } catch (e) {}
        });
        document.addEventListener('DOMContentLoaded', function() {
            const el = document.getElementById('calendar');
            window.calendar = new FullCalendar.Calendar(el, {
                initialView: 'dayGridMonth',
                height: 620,
                events: {
                    url: '{{ route('attendance.me.events') }}',
                    failure: () => window.toast.error('Calendar Error', 'Failed to load events'),
                },
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                }
            });
            window.calendar.render();
        });

        function getDT() {
            return (window.DT_INSTANCES && window.DT_INSTANCES['myAttendanceTable']) ?
                window.DT_INSTANCES['myAttendanceTable'] :
                ($.fn.dataTable.isDataTable('#myAttendanceTable') ? $('#myAttendanceTable').DataTable() : null);
        }
        $('#btnFilter').on('click', reloadMyTable);
        // $('#btnReset').on('click', reloadMyTable);
    </script>
    <script>
        function getDT() {
            return (window.DT_INSTANCES && window.DT_INSTANCES['myAttendanceTable']) ?
                window.DT_INSTANCES['myAttendanceTable'] :
                ($.fn.dataTable.isDataTable('#myAttendanceTable') ? $('#myAttendanceTable').DataTable() : null);
        }

        // زرّ Filter
        $('#btnFilter').on('click', function() {
            const dt = getDT();
            if (!dt) return console.warn('DataTable not ready');
            // لو فيه بحث عام سابق
            if (dt.search) dt.search('');
            // reload مع الفلاتر (attFilters hook هيبعت القيم)
            if (dt.ajax) dt.ajax.reload(null, false);
            else dt.draw(false);
        });

        // زرّ Reset
        $('#btnReset').on('click', function() {
            // صفّر الفلاتر
            $('#flt_status').val('');
            $('#flt_branch').val('');
            $('#flt_from').val('{{ now()->startOfMonth()->toDateString() }}');
            $('#flt_to').val('{{ now()->endOfMonth()->toDateString() }}');

            const dt = getDT();
            if (!dt) return console.warn('DataTable not ready');

            // امسح أي بحث عام
            if (dt.search) dt.search('');
            // ارجَع لأول صفحة
            if (dt.page) dt.page('first');
            // reload
            if (dt.ajax) dt.ajax.reload(null, false);
            else dt.draw(false);
        });
    </script>
    <script>
        // Toast عند اكتمال جلب الداتا/حدوث خطأ
        $('#myAttendanceTable')
            .on('xhr.dt', function(e, settings, json, xhr) {
                if (xhr && xhr.status !== 200) {
                    window.toast.fromResponse(xhr, 'Failed to load records');
                } else {
                    const cnt = (json && json.recordsFiltered != null) ?
                        json.recordsFiltered :
                        (json?.data?.length || 0);
                    window.toast.info('Records Loaded', `${cnt} row(s)`, 1200);
                }
            })
            .on('error.dt', function(e, settings, techNote, message) {
                window.toast.error('Table Error', message || 'Unexpected error');
            });

        // زرّ Filter
        $('#btnFilter').on('click', function() {
            const dt = getDT();
            if (!dt) return console.warn('DataTable not ready');
            if (dt.search) dt.search('');
            if (dt.ajax) dt.ajax.reload(null, false);
            else dt.draw(false);
            window.toast.info('Filter Applied', 'Reloading records…', 1200);
        });

        // زرّ Reset
        $('#btnReset').on('click', function() {
            $('#flt_status').val('');
            $('#flt_branch').val('');
            $('#flt_from').val('{{ now()->startOfMonth()->toDateString() }}');
            $('#flt_to').val('{{ now()->endOfMonth()->toDateString() }}');

            const dt = getDT();
            if (!dt) return console.warn('DataTable not ready');

            if (dt.search) dt.search('');
            if (dt.page) dt.page('first');
            if (dt.ajax) dt.ajax.reload(null, false);
            else dt.draw(false);
            window.toast.success('Filters Reset', 'Showing default range', 1200);
        });

        // Safety لأي Promise مرفوض بدون catch
        window.addEventListener('unhandledrejection', (ev) => {
            window.toast.error('Unexpected Error', (ev.reason && ev.reason.message) ? ev.reason.message :
                'Unknown');
        });
    </script>
@endpush
