{{-- resources/views/pages/notifications/index.blade.php --}}
@extends('layout.default')

@section('title', 'الإشعارات')

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        /* ===== Neon UI ===== */
        :root {
            --bg: #0b0f1a;
            --panel: #0f1629;
            --muted: #8aa2c0;
            --text: #e6f1ff;
            --neon: #00e5ff;
            /* Cyan */
            --neon2: #9a6bff;
            /* Purple */
            --ok: #2ce39a;
            --warn: #ffcc00;
            --err: #ff5c7a;
        }

        body {
            background: radial-gradient(1200px 600px at 10% -10%, rgba(0, 229, 255, .06), transparent 60%),
                radial-gradient(900px 500px at 110% -20%, rgba(154, 107, 255, .08), transparent 60%);
        }

        .nx-container {
            max-width: 960px;
            margin: 0 auto;
        }

        .nx-card {
            background: linear-gradient(180deg, rgba(255, 255, 255, .02), rgba(255, 255, 255, .01));
            border: 1px solid rgba(255, 255, 255, .08);
            border-radius: 20px;
            box-shadow: 0 0 0 1px rgba(0, 229, 255, .08), 0 20px 40px rgba(0, 0, 0, .35);
            backdrop-filter: blur(10px);
        }

        .nx-title {
            font-weight: 800;
            letter-spacing: .5px;
            color: var(--text);
            text-shadow: 0 0 12px rgba(0, 229, 255, .4);
        }

        .nx-sub {
            color: var(--muted);
        }

        .nx-btn {
            border: 1px solid rgba(255, 255, 255, .12);
            color: var(--text);
            background: linear-gradient(180deg, rgba(0, 229, 255, .12), rgba(154, 107, 255, .12));
            border-radius: 12px;
            padding: 10px 14px;
            transition: .2s ease;
        }

        .nx-btn:hover {
            filter: brightness(1.08);
            transform: translateY(-1px);
        }

        .nx-input {
            background: rgba(255, 255, 255, .06);
            border: 1px solid rgba(255, 255, 255, .12);
            color: var(--text);
            border-radius: 12px;
            height: 42px;
            padding: 10px 14px;
            outline: none;
        }

        .nx-input::placeholder {
            color: #9db2cd;
        }

        .nx-toggle {
            background: rgba(255, 255, 255, .06);
            border: 1px solid rgba(255, 255, 255, .12);
            border-radius: 12px;
            padding: 4px;
            display: inline-flex;
            gap: 4px;
        }

        .nx-toggle .opt {
            padding: 7px 10px;
            border-radius: 10px;
            cursor: pointer;
            color: var(--muted);
        }

        .nx-toggle .opt.active {
            color: var(--text);
            background: linear-gradient(180deg, rgba(0, 229, 255, .18), rgba(154, 107, 255, .18));
            box-shadow: 0 0 10px rgba(0, 229, 255, .25);
        }

        .nx-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nx-item {
            display: grid;
            grid-template-columns: 42px 1fr auto;
            gap: 12px;
            padding: 14px 16px;
            border-bottom: 1px dashed rgba(255, 255, 255, .08);
            align-items: center;
            transition: .15s ease;
        }

        .nx-item:hover {
            background: rgba(0, 229, 255, .06);
        }

        .nx-item .icon {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            display: grid;
            place-items: center;
            color: var(--neon);
            background: rgba(0, 229, 255, .09);
            box-shadow: inset 0 0 12px rgba(0, 229, 255, .3);
            font-size: 18px;
        }

        .nx-item .title {
            color: var(--text);
            font-weight: 700;
        }

        .nx-item .body {
            color: var(--muted);
            font-size: 13px;
        }

        .nx-item .time {
            color: #9db2cd;
            font-size: 12px;
            white-space: nowrap;
        }

        .nx-status {
            display: inline-block;
            font-size: 11px;
            padding: 2px 8px;
            border-radius: 999px;
            border: 1px solid rgba(255, 255, 255, .12);
            color: var(--text);
        }

        .nx-status.ok {
            background: rgba(44, 227, 154, .15);
            border-color: rgba(44, 227, 154, .35);
        }

        .nx-status.warn {
            background: rgba(255, 204, 0, .15);
            border-color: rgba(255, 204, 0, .35);
        }

        .nx-status.err {
            background: rgba(255, 92, 122, .15);
            border-color: rgba(255, 92, 122, .35);
        }

        .nx-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: var(--neon);
            display: inline-block;
            box-shadow: 0 0 8px var(--neon);
        }

        .nx-empty {
            text-align: center;
            padding: 40px 20px;
            color: var(--muted);
        }
    </style>

    <div class="nx-container my-4">
        <div class="d-flex justify-content-between align-items-end mb-3">
            <div>
                <h2 class="nx-title mb-1">لوحة الإشعارات</h2>
                <div class="nx-sub">كل ما يخص الإجازات والأذونات في مكان واحد ✨</div>
            </div>
            <div class="d-flex gap-2">
                <div class="nx-toggle" id="filterToggle">
                    <div class="opt active" data-filter="all">الكل</div>
                    <div class="opt" data-filter="unread">غير المقروء</div>
                </div>
                <button id="markAll" class="nx-btn">
                    <i class="bi bi-check2-all me-1"></i> تعليم الكل كمقروء
                </button>
            </div>
        </div>

        <div class="mb-3 d-flex gap-2">
            <div class="flex-grow-1">
                <input id="q" class="nx-input w-100" type="text" placeholder="ابحث في العنوان أو المحتوى...">
            </div>
            <div class="nx-btn" id="refreshBtn" title="تحديث">
                <i class="bi bi-arrow-repeat"></i>
            </div>
        </div>

        <div class="nx-card">
            <ul class="nx-list" id="list">
                @php
                    // نحتاج Carbon لعرض الوقت بشكل ودي
                    use Carbon\Carbon;
                    $iconOf = function ($model) {
                        return match ($model) {
                            'vacation' => 'bi-umbrella',
                            'attendance_permit' => 'bi-alarm',
                            default => 'bi-bell',
                        };
                    };
                    $statusClass = function ($s) {
                        $s = strtolower((string) $s);
                        return str_contains($s, 'reject')
                            ? 'err'
                            : (str_contains($s, 'approve')
                                ? 'ok'
                                : ($s === 'pending'
                                    ? 'warn'
                                    : ''));
                    };
                @endphp

                @forelse ($items as $it)
                    @php
                        $model = $it['status'] ? $it['status'] : '';
                        $icon = $iconOf($it['status'] === null ? '' : $it['status']);
                        // الفعلي للآيكون من data->model إن توفّر
                        $modelKey = data_get($it, 'model', data_get($it, 'data.model', null)); // احتياطي فقط
                        $icon = $iconOf($modelKey);

                        $title = $it['title'] ?? 'تنبيه';
                        $body = $it['body'] ?? '';
                        $time = $it['created_at'] ? Carbon::parse($it['created_at'])->diffForHumans() : '';
                        $status = $it['status'] ?? null;
                        $cls = $statusClass($status);
                        $isRead = !empty($it['read_at']);
                        $openHref = route('notifications.open.id', $it['id']); // المرور على الـ controller (mark-as-read + redirect)
                    @endphp

                    <li class="nx-item" data-title="{{ Str::lower($title) }}" data-body="{{ Str::lower($body) }}"
                        data-read="{{ $isRead ? '1' : '0' }}">
                        <div class="icon">
                            <i class="bi {{ $icon }}"></i>
                        </div>

                        <div>
                            <div class="d-flex align-items-center gap-2">
                                <a href="{{ $openHref }}" class="title text-decoration-none">{{ $title }}</a>
                                @if (!$isRead)
                                    <span class="nx-dot" title="غير مقروء"></span>
                                @endif
                                @if ($status)
                                    <span class="nx-status {{ $cls }}">{{ $status }}</span>
                                @endif
                            </div>
                            @if ($body)
                                <div class="body mt-1">{{ $body }}</div>
                            @endif
                        </div>

                        <div class="text-end">
                            <div class="time mb-2">{{ $time }}</div>
                            <div class="d-flex gap-2 justify-content-end">
                                @if (!$isRead)
                                    <button class="btn btn-sm btn-outline-light" data-action="read"
                                        data-id="{{ $it['id'] }}" title="تعليم كمقروء">
                                        <i class="bi bi-check2"></i>
                                    </button>
                                @endif
                                <a href="{{ $openHref }}" class="btn btn-sm btn-outline-info" title="فتح">
                                    <i class="bi bi-box-arrow-up-right"></i>
                                </a>
                            </div>
                        </div>
                    </li>
                @empty
                    <div class="nx-empty">لا توجد إشعارات بعد ✨</div>
                @endforelse
            </ul>
        </div>
    </div>

    {{-- ===== Scripts ===== --}}
    <script>
        const csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        function toast(msg = 'تم', type = 'success') {
            if (!window.Swal) {
                alert(msg);
                return;
            }
            Swal.fire({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 2200,
                icon: type,
                title: msg,
                background: 'rgba(15, 22, 41, .96)',
                color: '#e6f1ff'
            });
        }

        // فلترة/بحث
        const filterToggle = document.getElementById('filterToggle');
        const q = document.getElementById('q');
        const list = document.getElementById('list');

        function applyFilter() {
            const mode = filterToggle.querySelector('.opt.active')?.dataset.filter || 'all';
            const term = (q.value || '').toLowerCase().trim();

            list.querySelectorAll('.nx-item').forEach(li => {
                const isUnread = li.dataset.read === '0';
                const matchTerm = !term ||
                    li.dataset.title.includes(term) ||
                    li.dataset.body.includes(term);

                let show = matchTerm;
                if (mode === 'unread') show = show && isUnread;

                li.style.display = show ? '' : 'none';
            });
        }

        filterToggle.addEventListener('click', (e) => {
            const opt = e.target.closest('.opt');
            if (!opt) return;
            filterToggle.querySelectorAll('.opt').forEach(o => o.classList.remove('active'));
            opt.classList.add('active');
            applyFilter();
        });

        q.addEventListener('input', () => applyFilter());

        // Mark as read (single)
        list.addEventListener('click', async (e) => {
            const btn = e.target.closest('[data-action="read"]');
            if (!btn) return;
            e.preventDefault();

            const id = btn.dataset.id;
            btn.disabled = true;

            try {
                const res = await fetch(`{{ route('notifications.read', ':id') }}`.replace(':id', id), {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'Accept': 'application/json'
                    }
                });
                if (res.ok) {
                    toast('تم التعليم كمقروء');
                    // تحديث شكل الصف
                    const li = btn.closest('.nx-item');
                    if (li) {
                        li.dataset.read = '1';
                        const dot = li.querySelector('.nx-dot');
                        if (dot) dot.remove();
                        btn.remove();
                        applyFilter();
                    }
                } else {
                    toast('تعذّر التعليم الآن', 'error');
                }
            } catch {
                toast('تعذّر الاتصال بالخادم', 'error');
            } finally {
                btn.disabled = false;
            }
        });

        // Mark all read
        document.getElementById('markAll').addEventListener('click', async () => {
            const ok = confirm('تأكيد: تعليم كل الإشعارات كمقروء؟');
            if (!ok) return;
            try {
                const res = await fetch(`{{ route('notifications.read-all') }}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrf,
                        'Accept': 'application/json'
                    }
                });
                if (res.ok) {
                    toast('تم تعليم الكل كمقروء');
                    // حدث الواجهة
                    list.querySelectorAll('.nx-item').forEach(li => {
                        li.dataset.read = '1';
                        const dot = li.querySelector('.nx-dot');
                        if (dot) dot.remove();
                        const btn = li.querySelector('[data-action="read"]');
                        if (btn) btn.remove();
                    });
                    applyFilter();
                } else {
                    toast('تعذّر التنفيذ', 'error');
                }
            } catch {
                toast('تعذّر الاتصال بالخادم', 'error');
            }
        });

        // Refresh count (اختياري لعرض عداد في مكان آخر إن وُجد)
        async function refreshUnreadBadge() {
            try {
                const res = await fetch(`{{ route('notifications.unread-count') }}`);
                const data = await res.json();
                const badge = document.querySelector('#notif-badge');
                if (badge) badge.textContent = data.count ?? 0;
            } catch {}
        }

        document.getElementById('refreshBtn').addEventListener('click', () => {
            // مجرد تحديث العداد (ولو عندك Ajax لإعادة التحميل ممكن تضيفه هنا)
            refreshUnreadBadge();
            toast('تم التحديث', 'info');
        });

        // تشغيل أولي
        applyFilter();
    </script>
@endsection
