@php
  $permitTypes = \App\Models\AttendancePermitType::query()->orderBy('display_name')->get();
@endphp

<div class="row g-2 align-items-end mb-3">
  <div class="col-md-3">
    <label class="form-label">بحث</label>
    <input type="text" id="fltSearch" class="form-control neon-select" placeholder="اسم موظف / نوع / سبب">
  </div>

  <div class="col-md-3">
    <label class="form-label">نوع الإذن</label>
    <select id="fltType" class="form-select neon-select">
      <option value="">الكل</option>
      @foreach($permitTypes as $t)
        <option value="{{ $t->id }}">{{ $t->display_name ?? $t->name }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-2">
    <label class="form-label">الحالة</label>
    <select id="fltStatus" class="form-select neon-select">
      <option value="">الكل</option>
      <option value="pending">قيد الانتظار</option>
      <option value="leader_approved">موافقة TL</option>
      <option value="hr_approved">موافقة HR</option>
      <option value="rejected">مرفوض</option>
      <option value="cancelled">ملغي</option>
    </select>
  </div>

  <div class="col-md-2">
    <label class="form-label">من</label>
    <input type="date" id="fltFrom" class="form-control neon-select">
  </div>
  <div class="col-md-2">
    <label class="form-label">إلى</label>
    <input type="date" id="fltTo" class="form-control neon-select">
  </div>

  <div class="col-12 text-end">
    <button type="button" class="btn btn-neon btn-neon-outline" id="btnReset">إعادة ضبط</button>
  </div>
</div>
