@php
    $permitTypes = \App\Models\AttendancePermitType::query()->orderBy('display_name')->get();
@endphp

<div class="modal fade" id="permitFormModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content rounded-3">
            <div class="modal-header">
                <h5 class="modal-title" id="permitFormTitle">إذن جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <form id="permitForm">
                    @csrf
                    <div class="mb-2">
                        <label class="form-label">نوع الإذن</label>
                        <select class="form-select" name="permit_type_id">
                            <option value="">— اختر —</option>
                            @foreach ($permitTypes as $t)
                                <option value="{{ $t->id }}">{{ $t->display_name ?? $t->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row g-2">
                        <div class="col">
                            <label class="form-label">بداية</label>
                            <input type="datetime-local" class="form-control" name="start_datetime" required>
                        </div>
                        <div class="col">
                            <label class="form-label">نهاية</label>
                            <input type="datetime-local" class="form-control" name="end_datetime" required>
                        </div>
                    </div>

                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="all_day" id="pf-all-day" value="1">
                        <label class="form-check-label" for="pf-all-day">
                            اليوم كله
                        </label>
                    </div>

                    <div class="mt-2">
                        <label class="form-label">سبب الإذن</label>
                        <textarea class="form-control" name="member_reason" rows="2" placeholder="اختياري"></textarea>
                    </div>

                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="needs_hr" id="pf-needs-hr" checked
                            value="1">
                        <label class="form-check-label" for="pf-needs-hr">
                            يحتاج موافقة HR
                        </label>
                    </div>

                    <div class="mt-3 text-end">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('js')
    <script>
        // ========== PermitUI Helper (توست + ريفرش الجدول) ==========
        window.PermitUI = window.PermitUI || {
            toast(msg, variant = 'info', title) {
                try {
                    if (window.toast && typeof window.toast[variant] === 'function') {
                        window.toast[variant](title || (variant === 'error' ? 'خطأ' : 'تم'), msg || '');
                    } else if (window.toast && typeof window.toast.success === 'function') {
                        window.toast.success(title || 'إشعار', msg || '');
                    } else {
                        alert((title ? title + ':\n' : '') + (msg || ''));
                    }
                } catch (e) {
                    alert(msg || '');
                }
            },
            fetchData() {
                // لو عندك DataTable مرتبط بالتصاريح
                if (window.PermitsTable && typeof window.PermitsTable.ajax === 'function') {
                    window.PermitsTable.ajax.reload(null, false);
                } else if (typeof window.reloadPermits === 'function') {
                    window.reloadPermits();
                } else {
                    location.reload();
                }
            }
        };

        // ========== Utilities لعرض أخطاء الحقول ==========
        function pfShowFieldErrors(form, errors) {
            // امسح الحالة القديمة
            form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
            form.querySelectorAll('.invalid-feedback').forEach(el => el.remove());

            if (!errors) return;

            Object.entries(errors).forEach(([name, messages]) => {
                const input = form.querySelector(`[name="${name}"]`);
                if (!input) return;
                input.classList.add('is-invalid');
                const fb = document.createElement('div');
                fb.className = 'invalid-feedback';
                fb.textContent = Array.isArray(messages) ? messages.join('، ') : String(messages || '');
                // حاول تضيف الرسالة تحت الحقل مباشرة
                if (input.parentElement) input.parentElement.appendChild(fb);
                else input.after(fb);
            });
        }

        // ========== Submit Handler لنموذج الإذن ==========
        document.getElementById('permitForm')?.addEventListener('submit', async function(e) {
            e.preventDefault();

            const f = e.target;
            const mode = f.dataset.mode || 'create';
            const id = f.dataset.id || null;

            const submitBtn = f.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.dataset._originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = 'جارٍ الحفظ...';
            }

            const fd = new FormData(f);

            // مهم: لو Edit استخدم method spoof بدل PUT مباشر (أضمن مع Laravel)
            let url = mode === 'edit' ? `{{ url('/permits') }}/${id}` : `{{ route('permits.store') }}`;
            if (mode === 'edit') fd.append('_method', 'PUT');

            try {
                const res = await fetch(url, {
                    method: 'POST', // دائمًا POST + _method عند الـ Edit
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json' // عشان Laravel يرجّع JSON منظّم
                    },
                    body: fd
                });

                const data = await res.json().catch(() => ({}));

                if (!res.ok) {
                    // 422 Validation Errors
                    if (res.status === 422) {
                        pfShowFieldErrors(f, data.errors || null);
                    }

                    const msg = data?.message ||
                        (data?.errors ? Object.values(data.errors).flat().join('\n') : null) ||
                        `HTTP ${res.status}`;

                    console.error('Permit store error:', {
                        status: res.status,
                        data
                    });
                    PermitUI.toast(msg || 'خطأ أثناء الحفظ. تأكد من الإدخالات.', 'error', 'خطأ');
                    return;
                }

                // نجاح
                pfShowFieldErrors(f, null);
                PermitUI.toast(data?.message || 'تم الحفظ', 'success', 'تم');

                const modalEl = document.getElementById('permitFormModal');
                if (modalEl && typeof bootstrap !== 'undefined') {
                    bootstrap.Modal.getInstance(modalEl)?.hide();
                }

                // حدّث الجدول/البيانات
                PermitUI.fetchData();

            } catch (err) {
                console.error(err);
                PermitUI.toast(err?.message || 'حدث خطأ غير متوقع', 'error', 'خطأ');
            } finally {
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = submitBtn.dataset._originalText || 'حفظ';
                }
            }
        });
    </script>
@endpush
