<div class="modal fade" id="permitModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content rounded-3">
            <div class="modal-header">
                <h5 class="modal-title">تفاصيل الإذن</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    <div class="col-md-6"><b>الموظف:</b> <span id="pm-emp"></span></div>
                    <div class="col-md-6"><b>النوع:</b> <span id="pm-type"></span></div>
                    <div class="col-12"><b>الفترة:</b> <span id="pm-period"></span></div>
                    <div class="col-12"><b>المدة:</b> <span id="pm-duration"></span></div>
                    <div class="col-12"><b>الحالة:</b> <span id="pm-status"></span></div>
                    <div class="col-12"><b>سبب العضو:</b>
                        <div id="pm-reason" class="mt-1"></div>
                    </div>

                    <div class="col-md-6"><b>قرار القائد:</b>
                        <div id="pm-leader-reason" class="mt-1 text-muted"></div>
                    </div>
                    <div class="col-md-6"><b>قرار HR:</b>
                        <div id="pm-hr-reason" class="mt-1 text-muted"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                @can('permits.leaderApprove')
                    <div id="pm-leader-actions" class="me-auto d-none">
                        <button class="btn btn-success btn-sm" onclick="PermitActions.leaderDecision('approve')">اعتماد
                            القائد</button>
                        <button class="btn btn-outline-danger btn-sm" onclick="PermitActions.leaderDecision('reject')">رفض
                            القائد</button>
                    </div>
                @endcan

                @can('permits.hrApprove')
                    <div id="pm-hr-actions" class="me-2 d-none">
                        <button class="btn btn-success btn-sm" onclick="PermitActions.hrDecision('approve')">اعتماد
                            HR</button>
                        <button class="btn btn-outline-danger btn-sm" onclick="PermitActions.hrDecision('reject')">رفض
                            HR</button>
                    </div>
                @endcan

                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        let CURRENT_PERMIT = null;

        function fillPermitModal(permit) {
            CURRENT_PERMIT = permit;

            const period = `${permit.start_datetime ?? ''} → ${permit.end_datetime ?? ''}`;
            const mins = permit.total_minutes ?? 0;
            const h = Math.floor(mins / 60),
                m = mins % 60;
            const dur = (h ? h + ' س ' : '') + (m ? m + ' د' : (h ? '' : '0 د'));

            document.getElementById('pm-emp').textContent = permit.employee?.name ?? ('#' + permit.employee_id);
            document.getElementById('pm-type').textContent = permit.type?.display_name ?? permit.type?.name ?? '-';
            document.getElementById('pm-period').textContent = period;
            document.getElementById('pm-duration').textContent = dur;
            document.getElementById('pm-status').innerHTML = PermitUI.statusBadge(permit.status);
            document.getElementById('pm-reason').textContent = permit.member_reason ?? '-';
            document.getElementById('pm-leader-reason').textContent = permit.leader_reason ?? '-';
            document.getElementById('pm-hr-reason').textContent = permit.hr_reason ?? '-';

            // أزرار القرارات حسب الحالة
            const leaderActions = document.getElementById('pm-leader-actions');
            const hrActions = document.getElementById('pm-hr-actions');
            leaderActions.classList.add('d-none');
            hrActions.classList.add('d-none');

            if (permit.status === 'pending') {
                // القائد يقدر يقرر
                @can('permits.leaderApprove')
                    leaderActions.classList.remove('d-none');
                @endcan
            }
            if (['leader_approved', 'pending'].includes(permit.status)) {
                // HR يقدر يقرر
                @can('permits.hrApprove')
                    hrActions.classList.remove('d-none');
                @endcan
            }
        }

        const PermitActions = {
            leaderDecision(decision) {
                if (!CURRENT_PERMIT) return;
                const reason = prompt('سبب قرار القائد (اختياري):') ?? '';
                const fd = new FormData();
                fd.append('decision', decision);
                fd.append('leader_reason', reason);
                fetch(`{{ url('/permits') }}/${CURRENT_PERMIT.id}/leader-approve`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: fd
                }).then(r => r.json()).then(res => {
                    PermitUI.toast(res.message || 'تم');
                    bootstrap.Modal.getInstance(document.getElementById('permitModal')).hide();
                    PermitUI.fetchData();
                }).catch(console.error);
            },
            hrDecision(decision) {
                if (!CURRENT_PERMIT) return;
                const reason = prompt('سبب قرار HR (اختياري):') ?? '';
                const fd = new FormData();
                fd.append('decision', decision);
                fd.append('hr_reason', reason);
                fetch(`{{ url('/permits') }}/${CURRENT_PERMIT.id}/hr-approve`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: fd
                }).then(r => r.json()).then(res => {
                    PermitUI.toast(res.message || 'تم');
                    bootstrap.Modal.getInstance(document.getElementById('permitModal')).hide();
                    PermitUI.fetchData();
                }).catch(console.error);
            }
        };
    </script>
@endpush
