@extends('layout.default')

@section('title', 'إنشاء إذن')

@push('css')
    {{-- لو حابب شكل HUD/Neon اللي عملناه قبل كده، بيشتغل أوتوماتيك مع الكلاسات --}}
@endpush

@section('content')
    <div class="row" dir="rtl">
        <div class="col-12 col-lg-10 mx-auto">
            <div class="hud-card mb-4">
                <div class="hud-card__head">
                    <div class="d-flex align-items-center gap-2">
                        <i class="bi bi-person-check"></i>
                        <h5 class="mb-0">إنشاء إذن</h5>
                    </div>
                    <a href="{{ route('permits.index') }}" class="btn btn-sm btn-hud-outline">
                        <i class="bi bi-arrow-right"></i> رجوع للقائمة
                    </a>
                </div>

                <div class="hud-card__body">
                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            <div class="fw-semibold mb-1">تأكد من الحقول التالية:</div>
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('permits.store') }}" method="POST" enctype="multipart/form-data"
                        class="needs-validation" novalidate>
                        @include('pages.permits._form')

                        <div class="mt-4 d-flex gap-2">
                            <button type="submit" class="btn btn-hud-solid">
                                <i class="bi bi-check2-circle ms-1"></i> إرسال الطلب
                            </button>
                            <a href="{{ route('permits.index') }}" class="btn btn-hud-outline">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // تفعيل تحقّق Bootstrap بالعربي
        (function() {
            'use strict';
            const forms = document.querySelectorAll('.needs-validation');
            Array.prototype.slice.call(forms).forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    if (!form.checkValidity()) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        })();
    </script>
@endpush
