@extends('layout.default')
@section('title', 'تعديل إذن')

@include('partial.theme.neon-vars')
@include('partial.toast-js')

@section('content')
<div class="container-fluid">
  <form id="permitEditForm" class="card hud-card">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <a href="{{ route('permits.show.page', $permit->id) }}" class="btn btn-outline-inverse btn-sm">← عرض</a>
        <h5 class="mb-0 text-inverse">تعديل إذن #{{ $permit->id }}</h5>
      </div>
      <a href="{{ route('permits.index') }}" class="btn btn-inverse btn-sm">القائمة</a>
    </div>

    <div class="card-body">
      @php $types = $types ?? \App\Models\AttendancePermitType::orderBy('display_name')->get(); @endphp
      @include('permits._form_fields', ['permit'=>$permit, 'types'=>$types])
    </div>

    <div class="card-footer text-end">
      <button type="submit" class="btn btn-theme">حفظ التعديلات</button>
    </div>
  </form>
</div>
@endsection

@push('js')
<script>
document.getElementById('permitEditForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const id  = {{ $permit->id }};
  const url = `{{ url('/permits') }}/${id}`;

  const fd = new FormData(e.target);
  const body = {};
  fd.forEach((v,k)=>{
    if (['all_day','needs_hr'].includes(k)) body[k] = (v === '1' || v === 'on') ? true : false;
    else body[k] = v;
  });

  try{
    const res = await fetch(url, {
      method:'PUT',
      headers:{
        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
        'Accept':'application/json',
        'Content-Type':'application/json'
      },
      body: JSON.stringify(body)
    });
    if(!res.ok) return window.toast.fromResponse?.(res,'خطأ') ?? alert('خطأ أثناء الحفظ');
    const data = await res.json().catch(()=>({}));
    window.toast?.success?.('تم', data?.message || 'تم الحفظ');
    location.href = `{{ route('permits.show.page', $permit->id) }}`;
  }catch(err){
    window.toast?.error?.('خطأ', err?.message || 'حدث خطأ غير متوقع');
  }
});
</script>
@endpush
