@extends('layout.default')
@section('title', 'طلبات الأذونات')

{{-- متغيّرات النيون --}}
@include('partial.theme.neon-vars')
{{-- نظام التوست الموحّد --}}
@include('partial.toast-js')
@push('css')
    <style>
        /* ===== Tokens (fallbacks فقط لو ناقصة من الثيم) ===== */
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        /* ===== Card ===== */
        .card-border {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
        }

        .card-header {
            border-bottom: 1px solid var(--border);
            padding: 12px 16px;
        }

        .card-body {
            padding: 16px;
        }

        /* ===== Heading ===== */
        .text-inverse {
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
            margin: 0;
            font-weight: 800;
        }

        /* ===== Buttons HUD ===== */
        .btn-inverse,
        .btn-outline-inverse,
        .btn-theme,
        .btn-success.btn-xs,
        .btn-danger.btn-xs {
            border-radius: 10px;
            transition: .18s ease;
            box-shadow: var(--glow);
        }

        .btn-inverse {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            border: 1px solid var(--border-2);
            color: #e9f6ff;
            padding: .45rem .8rem;
        }

        .btn-outline-inverse {
            background: transparent;
            color: #e9f6ff;
            border: 1px solid var(--border);
            padding: .45rem .8rem;
        }

        .btn-theme {
            background: transparent;
            color: #e9f6ff;
            border: 1px solid var(--border);
        }

        .btn-inverse:hover,
        .btn-outline-inverse:hover,
        .btn-theme:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .btn:focus {
            outline: none !important;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35) !important;
        }

        /* ===== Filters container (partial.filters) ===== */
        .filters-wrap .form-control {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .65rem;
        }

        .filters-wrap .form-control:focus {
            border-color: var(--border-2);
            box-shadow: var(--ring);
        }

        /* ===== DataTable HUD ===== */
        .dataTables_wrapper .dt-buttons .btn {
            @apply none;
            /* للسلامة؛ نتجاهل Tailwind إن وُجد */
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            border-radius: 10px;
            margin: 0 .25rem .5rem 0;
            padding: .4rem .8rem;
            box-shadow: var(--glow);
        }

        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .4rem .6rem;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:focus,
        .dataTables_wrapper .dataTables_length select:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        table.dataTable {
            color: #dce7ff;
            border-collapse: separate;
            border-spacing: 0;
        }

        table.dataTable thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        table.dataTable tbody td {
            border-color: rgba(0, 224, 255, .08);
        }

        table.dataTable tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* Pagination */
        .pagination .page-link {
            background: #0e1326;
            color: #cfe7ff;
            border: 1px solid var(--border);
        }

        .pagination .page-item.active .page-link {
            background: linear-gradient(90deg, rgba(0, 224, 255, .22), rgba(255, 95, 255, .18));
            border-color: var(--border-2);
            color: #fff;
            box-shadow: var(--glow);
        }

        /* Badges من partial.ui (هنا بس تحسين محيطي لو ناقص) */
        .badge-hud {
            border-radius: 10px;
            padding: .25rem .6rem;
            font-weight: 700;
            font-size: .75rem;
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }
    </style>
@endpush
{{-- شريحة UIDL الخاصة بالأذونات (Renderers) – موجودة تحت في @push('js') --}}
{{-- أصول الداتا تيبلز --}}
@include('partial.datatable.assets')

@section('content')
    <div class="container-fluid">
        <div class="card card-border">
            {{-- ===== Header ===== --}}
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0 neon-title">طلبات الأذونات</h5>

                <div class="d-flex align-items-center gap-2">
                    @can('permits.create')
                        <a href="#" class="btn btn-inverse btn-sm" data-bs-toggle="modal" data-bs-target="#permitFormModal">
                            إذن جديد
                        </a>
                    @endcan
                    <a href="#" class="btn btn-outline-inverse btn-theme" data-toggle="card-expand">
                        تكبير
                    </a>
                </div>
            </div>

            {{-- ===== Filters + Table ===== --}}
            <div class="card-body">
                @include('pages.permits._filters')

                {{-- الجدول العام عبر المهيّئ الموحد --}}
                @include('partial.datatable.init', [
                    'id' => 'permitsTable',
                    'ajax' => route('permits.dt'),
                    'columns' => [
                        ['data' => 'id'],
                        ['data' => 'employee_name'],
                        ['data' => 'type_name'],
                        ['data' => 'start_datetime'],
                        ['data' => 'end_datetime'],
                        ['data' => 'total_minutes'],
                        ['data' => null, 'orderable' => false, 'searchable' => false, 'render' => 'per_status'],
                        ['data' => null, 'orderable' => false, 'searchable' => false, 'render' => 'per_actions'],
                    ],
                    'order' => [[0, 'desc']],
                    'exportColumns' => [0, 1, 2, 3, 4, 5, 6],
                    'responsive' => 'inline',
                    'filtersHook' => 'perFilters',
                    'thead' => view('pages.permits.thead'),
                ])
            </div>
        </div>
    </div>

    {{-- مودال الإنشاء/التعديل (اختياري – لو هتستخدم نفس فورمنا) --}}
    @include('pages.permits._form')

    {{-- مودال العرض (لو محتاج تفتحه من النوتيفيكيشن) --}}
    @include('pages.permits._modal')
@endsection

@push('js')
    <script>
        // ---- 1) Hook الفلاتر للـ Ajax (بدون تغيير)
        window.perFilters = function() {
            return {
                type: document.getElementById('fltType')?.value || '',
                status: document.getElementById('fltStatus')?.value || '',
                date_from: document.getElementById('fltFrom')?.value || '',
                date_to: document.getElementById('fltTo')?.value || '',
                search: document.getElementById('fltSearch')?.value || ''
            };
        };

        // ---- 2) Renderers
        window.DT = window.DT || {};
        DT.renderers = DT.renderers || {};

        DT.renderers.per_status = function(_, row) {
            const status = (row.status_value || row.status || 'pending');
            const map = {
                pending: {
                    cls: 'badge-hud badge-hud--pending',
                    text: 'قيد الانتظار'
                },
                leader_approved: {
                    cls: 'badge-hud badge-hud--leader',
                    text: 'موافقة TL'
                },
                hr_approved: {
                    cls: 'badge-hud badge-hud--hr',
                    text: 'موافقة HR'
                },
                rejected: {
                    cls: 'badge-hud badge-hud--rejected',
                    text: 'مرفوض'
                },
                cancelled: {
                    cls: 'badge-hud badge-hud--rejected',
                    text: 'ملغي'
                },
            };
            const cfg = map[status] || map.pending;
            return `<span class="${cfg.cls}" title="${status}">${cfg.text}</span>`;
        };

        // الأساس لروابط الـ Blade pages
        const PAGE_BASE = `{{ url('/dashboard/attendance/permits') }}`;
        // الأساس للـ API routes الصحيحة
        const API_BASE = `{{ url('/permits') }}`;

        DT.renderers.per_actions = function(_, row) {
            const showUrl = `${PAGE_BASE}/${row.id}`;
            const editUrl = `${PAGE_BASE}/${row.id}/edit`;

            const btnShow = `<a href="${showUrl}" class="btn btn-inverse btn-xs">عرض</a>`;
            const btnEdit = row.can_update ?
                `<a href="${editUrl}" class="btn btn-outline-inverse btn-xs">تعديل</a>` :
                '';

            // TL
            const tlApproveBtn = row.can_leader_approve ?
                `<button class="btn btn-success btn-xs" data-action="leader-approve" data-id="${row.id}">اعتماد TL</button>` :
                '';
            const tlRejectBtn = row.can_leader_approve ?
                `<button class="btn btn-outline-danger btn-xs" data-action="leader-reject" data-id="${row.id}">رفض TL</button>` :
                '';

            // HR
            const hrApproveBtn = row.can_hr_approve ?
                `<button class="btn btn-success btn-xs" data-action="hr-approve" data-id="${row.id}">اعتماد HR</button>` :
                '';
            const hrRejectBtn = row.can_hr_approve ?
                `<button class="btn btn-outline-warning btn-xs" data-action="hr-reject" data-id="${row.id}">رفض HR</button>` :
                '';

            // Cancel (للصاحب أو حسب البوليسي)
            const cancelBtn = row.can_cancel && !['hr_approved', 'rejected', 'cancelled'].includes(row.status) ?
                `<button class="btn btn-danger btn-xs" data-action="cancel" data-id="${row.id}">إلغاء</button>` :
                '';

            const rightSide = [btnEdit, btnShow, tlApproveBtn, tlRejectBtn, hrApproveBtn, hrRejectBtn, cancelBtn]
                .filter(Boolean).join(' ');
            return `<div>${rightSide || '<span class="text-muted">—</span>'}</div>`;
        };

        window.DT.renderers.per_status = DT.renderers.per_status;
        window.DT.renderers.per_actions = DT.renderers.per_actions;

        // ---- 3) سلوك الفلاتر (بدون تغيير)
        (function() {
            const reload = () => window.DT_INSTANCES['permitsTable']?.ajax?.reload();
            let st;
            document.getElementById('fltSearch')?.addEventListener('input', () => {
                clearTimeout(st);
                st = setTimeout(reload, 300);
            });
            ['fltType', 'fltStatus', 'fltFrom', 'fltTo'].forEach(id => {
                document.getElementById(id)?.addEventListener('change', reload);
            });
            document.getElementById('btnReset')?.addEventListener('click', () => {
                ['fltSearch', 'fltType', 'fltStatus', 'fltFrom', 'fltTo'].forEach(id => {
                    const el = document.getElementById(id);
                    if (el) el.value = '';
                });
                reload();
            });
        })();

        // ---- 4) هاندلر الأكشنز: يضرب على /permits/{id}/... (API)
        document.addEventListener('click', async (e) => {
            const btn = e.target.closest('[data-action][data-id]');
            if (!btn) return;

            if (btn.dataset.busy === '1') return;
            btn.dataset.busy = '1';
            btn.disabled = true;

            const id = btn.dataset.id;
            const action = btn.dataset.action;

            // مهم: الأكشنز على API_BASE (مش صفحة الداشبورد)
            let url = `${API_BASE}/${id}`;
            if (action.startsWith('leader-')) url += '/leader-approve';
            else if (action.startsWith('hr-')) url += '/hr-approve';
            else if (action === 'cancel') url += '/cancel';

            let body = {};
            if (action === 'leader-approve') {
                body.decision = 'approve';
                const r = prompt('سبب القائد (اختياري):', '');
                if (r) body.leader_reason = r;
            } else if (action === 'leader-reject') {
                body.decision = 'reject';
                const r = prompt('سبب الرفض (اختياري):', '');
                if (r) body.leader_reason = r;
            } else if (action === 'hr-approve') {
                body.decision = 'approve';
                const r = prompt('سبب HR (اختياري):', '');
                if (r) body.hr_reason = r;
            } else if (action === 'hr-reject') {
                body.decision = 'reject';
                const r = prompt('سبب الرفض (اختياري):', '');
                if (r) body.hr_reason = r;
            } else if (action === 'cancel') {
                const r = prompt('سبب الإلغاء (اختياري):', '');
                if (r === null) {
                    btn.dataset.busy = '0';
                    btn.disabled = false;
                    return;
                }
                if (r) body.cancelled_reason = r;
            }

            try {
                const res = await fetch(url, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(body)
                });

                if (!res.ok) {
                    return window.toast.fromResponse?.(res, 'خطأ') ?? alert('خطأ');
                }

                const data = await res.json().catch(() => ({}));
                window.toast?.success?.('تم', data?.message || 'نُفِّذ الطلب بنجاح') ?? alert(data?.message ||
                    'تم');
                window.DT_INSTANCES?.['permitsTable']?.ajax?.reload(null, false);
            } catch (err) {
                window.toast?.error?.('خطأ', err?.message || 'حدث خطأ غير متوقّع') ?? alert('خطأ');
            } finally {
                btn.dataset.busy = '0';
                btn.disabled = false;
            }
        });

        // ---- 5) (اختياري) فتح مودال العرض من ?open=
        (function() {
            const p = new URLSearchParams(location.search);
            const open = p.get('open');
            if (!open) return;
            const [type, pid] = String(open).split(':');
            if (type === 'attendance_permit' && Number(pid) > 0) {
                fetch(`${PAGE_BASE}/${pid}`, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(r => r.json()).then(permit => {
                        fillPermitModal?.(permit);
                        new bootstrap.Modal(document.getElementById('permitModal')).show();
                    });
            }
        })();
    </script>
@endpush
