@php
  $createdAt = optional($permit->created_at)->format('Y-m-d H:i');
  $leaderAt  = optional($permit->leader_decision_at)->format('Y-m-d H:i');
  $hrAt      = optional($permit->hr_decision_at)->format('Y-m-d H:i');
  $statusVal = (string)($permit->status ?? 'pending');

  $steps = [
    ['label'=>'تم إنشاء الطلب', 'done'=>true, 'at'=>$createdAt],
    ['label'=>'اعتماد TL',      'done'=>in_array($statusVal, ['leader_approved','hr_approved','rejected']) && !!$leaderAt, 'at'=>$leaderAt],
    ['label'=>'اعتماد HR',      'done'=>($statusVal==='hr_approved') && !!$hrAt, 'at'=>$hrAt],
  ];
@endphp

<div class="meta-block mb-3">
  <div class="block-head">الحالة الزمنية</div>
  <div class="block-body">
    <div class="timeline">
      @foreach($steps as $s)
        <div class="timeline-item {{ $s['done']? 'done':'' }}">
          <span class="timeline-dot"></span>
          <div class="timeline-title">{{ $s['label'] }}</div>
          @if(!empty($s['at'])) <div class="timeline-sub">{{ $s['at'] }}</div> @endif
        </div>
      @endforeach
      @if($statusVal === 'cancelled')
        <div class="timeline-item done">
          <span class="timeline-dot"></span>
          <div class="timeline-title">تم الإلغاء</div>
          <div class="timeline-sub">{{ optional($permit->updated_at)->format('Y-m-d H:i') }}</div>
        </div>
      @endif
    </div>
  </div>
</div>
