@extends('layout.default')
@section('title', 'تفاصيل إذن الحضور/الانصراف')

{{-- HUD / Theme / Toast --}}
@include('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
<style>
  :root {
    --hud-accent: var(--bs-theme, #0ea5e9);
    --hud-accent-rgb: var(--bs-theme-rgb, 14,165,233);
    --hud-surface-1: var(--bs-body-bg, #0b0f1a);
    --hud-surface-2: color-mix(in oklab, var(--hud-accent) 4%, var(--hud-surface-1));
    --hud-border: var(--bs-border-color, rgba(255,255,255,.15));
    --hud-text: var(--bs-body-color, #e6f1ff);
    --hud-muted: var(--bs-secondary-color, rgba(148,163,184,.75));
    --hud-card: var(--bs-component-bg, #182230);
  }
  .hud-card{background:#28292b69;border:1px solid var(--hud-border);border-radius:.9rem;}
  .hud-card .card-header{border-bottom:1px dashed var(--hud-border);
    background:linear-gradient(180deg,color-mix(in oklab,var(--hud-accent) 6%,transparent),transparent);}
  .stat{background:linear-gradient(180deg,color-mix(in oklab,var(--hud-accent) 6%,var(--hud-surface-2)),var(--hud-surface-2));
    border:1px solid color-mix(in oklab,var(--hud-accent) 24%,var(--hud-border));border-radius:.8rem;padding:.8rem 1rem;height:100%;}
  .stat .label{font-size:.78rem;color:var(--hud-muted);margin-bottom:.25rem;}
  .stat .value{color:var(--hud-text);font-weight:600;letter-spacing:.3px;}
  .meta-block{border:1px solid var(--hud-border);border-radius:.8rem;background:var(--hud-surface-2);}
  .meta-block .block-head{padding:.65rem 1rem;border-bottom:1px dashed var(--hud-border);color:var(--hud-text);font-weight:600;}
  .meta-block .block-body{padding:.9rem 1rem;}
  .meta-field + .meta-field{margin-top:.85rem;}
  .meta-label{font-size:.78rem;color:var(--hud-muted);margin-bottom:.25rem;}
  .meta-value{color:var(--hud-text);white-space:pre-line;}

  .timeline{position:relative;padding-left:1rem;}
  .timeline::before{content:"";position:absolute;left:.32rem;top:.25rem;bottom:.25rem;width:2px;
    background:color-mix(in oklab,var(--hud-accent) 22%,var(--hud-border));border-radius:1px;}
  .timeline-item{position:relative;padding:.35rem 0 .35rem 1rem;}
  .timeline-dot{position:absolute;left:-.1rem;top:.55rem;width:.6rem;height:.6rem;border-radius:50%;
    background:var(--bs-gray-600);box-shadow:0 0 0 2px var(--hud-card);}
  .timeline-item.done .timeline-dot{background:rgb(var(--bs-success-rgb,60,210,165));
    box-shadow:0 0 8px rgba(var(--bs-success-rgb,60,210,165),.45);}
  .timeline-title{color:var(--hud-text);font-weight:500;}
  .timeline-sub{color:var(--hud-muted);font-size:.78rem;}

  .notes .note + .note{margin-top:.75rem;}
  .note .note-label{color:var(--hud-muted);font-size:.78rem;margin-bottom:.25rem;}
  .note .note-text{color:var(--hud-text);white-space:pre-line;}

  .btn-theme{--accent:var(--hud-accent);color:#fff;background:var(--accent);
    border-color:color-mix(in oklab,var(--accent) 65%,#0000);}
  .btn-theme:hover{filter:brightness(1.05);box-shadow:0 8px 20px rgba(var(--hud-accent-rgb),.22);}
  .btn-outline-inverse{border-color:var(--hud-border);color:var(--hud-text);}
  .btn-outline-inverse:hover{background:color-mix(in oklab,var(--hud-accent) 12%,transparent);}
  @media (max-width: 991.98px){ .stat{padding:.7rem .85rem;} }
</style>
@endpush

@section('content')
@php
  /** @var \App\Models\AttendancePermit $permit */
  $statusVal = (string)($permit->status ?? 'pending');
  $empName   = $permit->employee?->full_name ?: ($permit->employee?->user?->name ?? '—');
@endphp

<div class="container-fluid">
  <div class="card hud-card">
    {{-- ===== Header ===== --}}
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <a href="{{ route('permits.index') }}" class="btn btn-outline-inverse btn-sm">← رجوع</a>
        <h5 class="mb-0 text-inverse">إذن #{{ $permit->id }}</h5>
      </div>
      <div class="d-flex align-items-center gap-2">
        @include('pages.permits.partial.status-badge', ['status'=>$statusVal])
        <a href="#" class="btn btn-outline-inverse btn-theme btn-sm" data-toggle="card-expand">تكبير</a>
      </div>
    </div>

    {{-- ===== Summary Strip ===== --}}
    <div class="card-body pb-2">
      <div class="row g-3">
        <div class="col-12 col-md-6 col-lg-4">
          <div class="stat">
            <div class="label">الموظف</div>
            <div class="value" title="{{ $empName }}">{{ $empName }}</div>
          </div>
        </div>

        <div class="col-6 col-lg-2">
          <div class="stat">
            <div class="label">نوع الإذن</div>
            <div class="value">{{ $permit->type?->display_name ?? $permit->type?->name ?? '—' }}</div>
          </div>
        </div>

        <div class="col-6 col-lg-2">
          <div class="stat">
            <div class="label">البداية</div>
            <div class="value">{{ optional($permit->start_datetime)->format('Y-m-d H:i') }}</div>
          </div>
        </div>

        <div class="col-6 col-lg-2">
          <div class="stat">
            <div class="label">النهاية</div>
            <div class="value">{{ optional($permit->end_datetime)->format('Y-m-d H:i') }}</div>
          </div>
        </div>

        <div class="col-6 col-lg-2">
          <div class="stat">
            <div class="label">المدة (دقيقة)</div>
            <div class="value">{{ (int) $permit->total_minutes }}</div>
          </div>
        </div>
      </div>
    </div>

    {{-- ===== Content (2 columns) ===== --}}
    <div class="card-body pt-2">
      <div class="row g-3">
        {{-- يسار: تفاصيل الطلب --}}
        <div class="col-lg-8">
          <div class="meta-block mb-3">
            <div class="block-head">تفاصيل الإذن</div>
            <div class="block-body">
              <div class="meta-field">
                <div class="meta-label">سبب الطلب</div>
                <div class="meta-value">{{ $permit->member_reason ?: '— لا يوجد سبب مُدخل —' }}</div>
              </div>

              <div class="meta-field">
                <div class="meta-label">خصائص</div>
                <div class="meta-value">
                  • اليوم كله: <b>{{ $permit->all_day ? 'نعم' : 'لا' }}</b>  —
                  • يحتاج HR: <b>{{ $permit->needs_hr ? 'نعم' : 'لا' }}</b>
                </div>
              </div>

              <div class="meta-field">
                <div class="meta-label">حالة الطلب</div>
                @include('pages.permits.partial.status-badge', ['status'=>$statusVal])
              </div>
            </div>
          </div>
        </div>

        {{-- يمين: التايملاين + الملاحظات + الإجراءات --}}
        <div class="col-lg-4">
          @include('pages.permits.partial.timeline', ['permit'=>$permit])

          <div class="meta-block mb-3 notes">
            <div class="block-head">سجلّ الملاحظات</div>
            <div class="block-body">
              <div class="note">
                <div class="note-label">ملاحظة TL</div>
                <div class="note-text">{{ $permit->leader_reason ?: '— لا توجد —' }}</div>
              </div>
              <div class="note">
                <div class="note-label">ملاحظة HR</div>
                <div class="note-text">{{ $permit->hr_reason ?: '— لا توجد —' }}</div>
              </div>
            </div>
          </div>

          <div class="meta-block">
            <div class="block-head d-flex align-items-center justify-content-between">
              <span>إجراءات</span>
            </div>
            <div class="block-body d-flex flex-wrap gap-2">
              @can('update',$permit)
                @if($permit->status === 'pending')
                  <a href="{{ route('permits.edit.page',$permit->id) }}" class="btn btn-outline-inverse btn-sm">تعديل</a>
                @endif
              @endcan

              @can('leaderApprove',$permit)
                @if($permit->status === 'pending')
                  <button class="btn btn-theme btn-sm js-perm-action" data-action="leader-approve">اعتماد TL</button>
                  <button class="btn btn-outline-inverse btn-sm js-perm-action" data-action="leader-reject">رفض TL</button>
                @endif
              @endcan

              @can('hrApprove',$permit)
                @if(in_array($permit->status, ['leader_approved','pending']))
                  <button class="btn btn-theme btn-sm js-perm-action" data-action="hr-approve">اعتماد HR</button>
                  <button class="btn btn-outline-inverse btn-sm js-perm-action" data-action="hr-reject">رفض HR</button>
                @endif
              @endcan

              @can('cancel',$permit)
                @if(!in_array($permit->status, ['hr_approved','rejected','cancelled']))
                  <button class="btn btn-outline-inverse btn-sm js-perm-action" data-action="cancel">إلغاء الطلب</button>
                @endif
              @endcan

              <a href="{{ route('permits.index') }}" class="btn btn-inverse btn-sm">رجوع للقائمة</a>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

{{-- Toast container (لو مش موجود في الـ layout) --}}
<div class="toast-container position-fixed top-0 end-0 p-3" id="toastContainer" style="z-index:1080;"></div>
@endsection

@push('js')
<script>
(function(){
  const id   = {{ $permit->id }};
  const base = `{{ url('/permits') }}/${id}`;

  async function postJson(url, body){
    const res = await fetch(url, {
      method:'POST',
      headers:{
        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
        'Accept':'application/json',
        'Content-Type':'application/json'
      },
      body: JSON.stringify(body || {})
    });
    if (!res.ok) return window.toast.fromResponse?.(res,'خطأ') ?? alert('خطأ');
    const data = await res.json().catch(()=>({}));
    window.toast?.success?.('تم', data?.message || 'نُفِّذ الطلب بنجاح');
    setTimeout(()=> location.reload(), 500);
  }

  document.addEventListener('click', (e)=>{
    const btn = e.target.closest('.js-perm-action'); if(!btn) return;
    const action = btn.dataset.action;

    if (action === 'leader-approve') {
      const r = prompt('سبب القائد (اختياري):','');
      postJson(`${base}/leader-approve`, { decision:'approve', leader_reason: r||null });
    } else if (action === 'leader-reject') {
      const r = prompt('سبب الرفض (اختياري):','');
      if (r === null) return;
      postJson(`${base}/leader-approve`, { decision:'reject', leader_reason: r||null });
    } else if (action === 'hr-approve') {
      const r = prompt('سبب HR (اختياري):','');
      postJson(`${base}/hr-approve`, { decision:'approve', hr_reason: r||null });
    } else if (action === 'hr-reject') {
      const r = prompt('سبب الرفض (اختياري):','');
      if (r === null) return;
      postJson(`${base}/hr-approve`, { decision:'reject', hr_reason: r||null });
    } else if (action === 'cancel') {
      const r = prompt('سبب الإلغاء (اختياري):','');
      if (r === null) return;
      postJson(`${base}/cancel`, { cancelled_reason: r||null });
    }
  });
})();
</script>
@endpush
