@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appClass' => 'app-content-full-height app-without-sidebar app-without-header',
	'appContentClass' => 'p-1 ps-xl-4 pe-xl-4 pt-xl-3 pb-xl-3'
])

@section('title', 'Counter Checkout')

@push('js')
  <script src="/assets/js/demo/pos-counter-checkout.demo.js"></script>
@endpush

@section('content')
	<!-- BEGIN pos -->
	<div class="pos pos-vertical card" id="pos">
		<!-- BEGIN pos-container -->
		<div class="pos-container card-body">
			<!-- BEGIN pos-header -->
			<div class="pos-header">
				<div class="logo">
					<a href="/pos/counter-checkout">
						<div class="logo-img"><i class="bi bi-x-diamond" style="font-size: 1.5rem;"></i></div>
						<div class="logo-text">Pine & Dine</div>
					</a>
				</div>
				<div class="time" id="time">00:00</div>
				<div class="nav">
					<div class="nav-item">
						<a href="/pos/kitchen-order" class="nav-link">
							<i class="bi bi-bootstrap-reboot nav-icon"></i>
						</a>
					</div>
					<div class="nav-item">
						<a href="/pos/table-booking" class="nav-link">
							<i class="bi bi-calendar-date nav-icon"></i>
						</a>
					</div>
					<div class="nav-item">
						<a href="/pos/menu-stock" class="nav-link">
							<i class="bi bi-pie-chart nav-icon"></i>
						</a>
					</div>
				</div>
			</div>
			<!-- END pos-header -->
			
			<!-- BEGIN pos-content -->
			<div class="pos-content">
				<div class="pos">
					<div class="pos-container">
					<!-- BEGIN pos-counter-content -->
					<div class="pos-content h-100">
						<div class="pos-content-container p-3" data-scrollbar="true" data-height="100%">
							<div class="row gx-3">
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">1</div>
												<div class="text-inverse text-opacity-50">9 order</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">4 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">35:20</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$318.20</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">Unpaid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">2</div>
												<div class="text-inverse text-opacity-50">12 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">6 / 8</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">12:69</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$682.20</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">Unpaid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">3</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">4</div>
												<div class="text-inverse text-opacity-50">max 4 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">5</div>
												<div class="text-inverse text-opacity-50">max 4 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">6</div>
												<div class="text-inverse text-opacity-50">3 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">3 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">20:52</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$56.49</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">Unpaid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">7</div>
												<div class="text-inverse text-opacity-50">6 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">3 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">58:40</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$329.02</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-success"></i></div>
														<div class="w-60px text-success">Paid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">8</div>
												<div class="text-inverse text-opacity-50">0 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">2 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">05:12</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$329.02</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">Unpaid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">9</div>
												<div class="text-inverse text-opacity-50">4 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">2 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">52:58</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$49.50</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">Unpaid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table in-use card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">10</div>
												<div class="text-inverse text-opacity-50">12 orders</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">9 / 12</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">66:69</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">$768.24</div>
													</div>
													<div class="col-6 d-flex justify-content-center text-success">
														<div class="w-20px"><i class="bi bi-currency-dollar"></i></div>
														<div class="w-60px">Paid</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table disabled card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">11</div>
												<div class="text-inverse text-opacity-50">Reserved for Sean</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 4</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">12</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">13</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">14</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">15</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">16</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">17</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">18</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">19</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
								<div class="col-xl-3 col-lg-4 col-md-6 pb-3">
									<div class="pos-checkout-table available card">
										<a href="#" class="pos-checkout-table-container" data-toggle="select-table">
											<div class="pos-checkout-table-header">
												<div class="status"><i class="bi bi-circle-fill"></i></div>
												<div class="fw-bold">Table</div>
												<div class="fw-bold display-6">20</div>
												<div class="text-inverse text-opacity-50">max 6 pax</div>
											</div>
											<div class="pos-checkout-table-info small">
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-people text-inverse text-opacity-50"></i></div>
														<div class="w-60px">0 / 6</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-clock text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
												<div class="row">
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-receipt text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
													<div class="col-6 d-flex justify-content-center">
														<div class="w-20px"><i class="bi bi-currency-dollar text-inverse text-opacity-50"></i></div>
														<div class="w-60px">-</div>
													</div>
												</div>
											</div>
										</a>
										
										<!-- BEGIN card-arrow -->
										<div class="card-arrow">
											<div class="card-arrow-top-left"></div>
											<div class="card-arrow-top-right"></div>
											<div class="card-arrow-bottom-left"></div>
											<div class="card-arrow-bottom-right"></div>
										</div>
										<!-- END card-arrow -->
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- END pos-counter-content -->
		
					<!-- BEGIN pos-sidebar -->
					<div class="pos-sidebar" id="pos-sidebar">
						<!-- BEGIN pos-sidebar-header -->
						<div class="pos-sidebar-header">
							<div class="back-btn">
								<button type="button" data-toggle-class="pos-mobile-sidebar-toggled" data-toggle-target="#pos" class="btn">
									<i class="bi bi-chevron-left"></i>
								</button>
							</div>
							<div class="icon"><img src="/assets/img/pos/icon-table-black.svg" class="invert-dark" alt=""></div>
							<div class="title">Table 01</div>
							<div class="order">Order: <b class="text-theme">#0000</b></div>
						</div>
						<!-- END pos-sidebar-header -->
						<hr class="m-0 opacity-3 text-inverse">
						<!-- BEGIN pos-sidebar-body -->
						<div class="pos-sidebar-body" data-scrollbar="true" data-height="100%">
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-2.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Grill Pork Chop</div>
												<div class="small">$12.99</div>
												<div class="small">- size: large</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$12.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-8.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Orange Juice</div>
												<div class="small">$5.00</div>
												<div class="small">- size: large<br>- less ice</div>
											</div>
											<div class="col-2">x2</div>
											<div class="col-3 text-inverse fw-bold text-end">$10.00</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-13.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Vanilla Ice-cream</div>
												<div class="small">$3.99</div>
												<div class="small">- scoop: 1 <br>- flavour: vanilla</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$3.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-1.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Grill chicken chop</div>
												<div class="small">$3.99</div>
												<div class="small">- size: large<br>- spicy: medium</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$10.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-10.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Mushroom Soup</div>
												<div class="small">$3.99</div>
												<div class="small">- size: large<br>- more cheese</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$3.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-5.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Hawaiian Pizza</div>
												<div class="small">$15.00</div>
												<div class="small">- size: large<br>- more onion</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$15.00</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-15.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Perfect Yeast Doughnuts</div>
												<div class="small">$2.99</div>
												<div class="small">- size: 1 set<br>- flavour: random</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$2.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
							<!-- BEGIN pos-order -->
							<div class="pos-order py-3">
								<div class="pos-order-product">
									<div class="img w-40px h-40px" style="background-image: url(/assets/img/pos/product-14.jpg)"></div>
									<div class="flex-1">
										<div class="row">
											<div class="col-7">
												<div class="h6 mb-1">Macarons</div>
												<div class="small">$4.99</div>
												<div class="small">- size: 1 set<br>- flavour: random</div>
											</div>
											<div class="col-2">x1</div>
											<div class="col-3 text-inverse fw-bold text-end">$4.99</div>
										</div>
									</div>
								</div>
							</div>
							<!-- END pos-order -->
						</div>
						<!-- END pos-sidebar-body -->
						<!-- BEGIN pos-sidebar-footer -->
						<div class="pos-sidebar-footer">
							<div class="d-flex align-items-center mb-2">
								<div>Subtotal</div>
								<div class="flex-1 text-end h6 mb-0">$64.94</div>
							</div>
							<div class="d-flex align-items-center">
								<div>Taxes (6%)</div>
								<div class="flex-1 text-end h6 mb-0">$3.90</div>
							</div>
							<hr>
							<div class="d-flex align-items-center mb-2">
								<div>Total</div>
								<div class="flex-1 text-end h4 mb-0">$68.84</div>
							</div>
							<div class="mt-3">
								<div class="btn-group d-flex">
									<a href="#" class="btn btn-outline-default rounded-0 w-80px">
										<i class="bi bi-paypal fa-lg"></i><br>
										<span class="small">E-Wallet</span>
									</a>
									<a href="#" class="btn btn-outline-default rounded-0 w-80px">
										<i class="bi bi-credit-card fa-fw fa-lg"></i><br>
										<span class="small">Card</span>
									</a>
									<a href="#" class="btn btn-outline-theme rounded-0 w-150px">
										<i class="bi bi-wallet2 fa-lg"></i><br>
										<span class="small">Cash</span>
									</a>
								</div>
							</div>
						</div>
						<!-- END pos-sidebar-footer -->
					</div>
					<!-- END pos-sidebar -->
					</div>
				</div>
			</div>
			<!-- END pos-content -->
		</div>
		<!-- END pos-container -->
		
		<!-- BEGIN card-arrow -->
		<div class="card-arrow">
			<div class="card-arrow-top-left"></div>
			<div class="card-arrow-top-right"></div>
			<div class="card-arrow-bottom-left"></div>
			<div class="card-arrow-bottom-right"></div>
		</div>
		<!-- END card-arrow -->
	</div>
	<!-- END pos -->
@endsection
