@extends('layout.default', [
	'bodyClass' => 'pace-top',
	'appHeaderHide' => true,
	'appSidebarHide' => true,
	'appClass' => 'app-content-full-height app-without-sidebar app-without-header',
	'appContentClass' => 'p-1 ps-xl-4 pe-xl-4 pt-xl-3 pb-xl-3'
])

@section('title', 'Kitchen Order')

@push('js')
	<script src="/assets/js/demo/pos-kitchen-order.demo.js"></script>
@endpush

@section('content')
  <!-- BEGIN pos -->
	<div class="pos pos-vertical card" id="pos">
		<!-- BEGIN pos-container -->
		<div class="pos-container card-body">
			<!-- BEGIN pos-header -->
			<div class="pos-header">
				<div class="logo">
					<a href="/pos/counter-checkout">
						<div class="logo-img"><i class="bi bi-x-diamond" style="font-size: 1.5rem;"></i></div>
						<div class="logo-text">Pine & Dine</div>
					</a>
				</div>
				<div class="time" id="time">00:00</div>
				<div class="nav">
					<div class="nav-item">
						<a href="/pos/kitchen-order" class="nav-link">
							<i class="bi bi-bootstrap-reboot nav-icon"></i>
						</a>
					</div>
					<div class="nav-item">
						<a href="/pos/table-booking" class="nav-link">
							<i class="bi bi-calendar-date nav-icon"></i>
						</a>
					</div>
					<div class="nav-item">
						<a href="/pos/menu-stock" class="nav-link">
							<i class="bi bi-pie-chart nav-icon"></i>
						</a>
					</div>
				</div>
			</div>
			<!-- END pos-header -->

			<!-- BEGIN pos-content -->
			<div class="pos-content">
				<div class="pos-content-container h-100 p-0" data-scrollbar="true" data-height="100%">
					<div class="pos-task">
						<div class="pos-task-info">
							<div class="h3 mb-1">Table 05</div>
							<div class="mb-3">Order No: #9049</div>
							<div class="mb-2">
								<span class="badge bg-success text-black fs-14px">Dine-in</span>
							</div>
							<div>07:13 time</div>
						</div>
						<div class="pos-task-body">
							<div class="fs-16px mb-3">
								Completed: (1/3)
							</div>
							<div class="row gx-4">
								<div class="col-lg-3">
									<div class="pos-task-product">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-2.jpg);"></div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Pork Burger</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- large size<br>
													- extra cheese
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success">Complete</a>
											<a href="#" class="btn btn-outline-default">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-14.jpg);"></div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Macarons</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- serve after dishes
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success">Complete</a>
											<a href="#" class="btn btn-outline-default">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-8.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Vita C Detox Juice</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- large size<br>
													- less ice<br>
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="pos-task">
						<div class="pos-task-info">
							<div class="h3 mb-1">Table 14</div>
							<div class="mb-3">Order No: #9047</div>
							<div class="mb-2">
								<span class="badge bg-success text-black fs-14px">Dine-in</span>
							</div>
							<div><span class="text-danger">12:13</span> time</div>
						</div>
						<div class="pos-task-body">
							<div class="fs-16px mb-3">
								Completed: (3/4)
							</div>
							<div class="row gx-4">
								<div class="col-lg-3">
									<div class="pos-task-product">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-11.jpg);"></div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Baked chicken wing</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- 6 pieces<br>
													- honey source<br>
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success">Complete</a>
											<a href="#" class="btn btn-outline-default">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-12.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Veggie Spaghetti</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- size: large <br>
													- spicy level: light
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-7.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Coffee Latte</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- no sugar<br>
													- more cream
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-1.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Grill Chicken Chop</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="pos-task">
						<div class="pos-task-info">
							<div class="h3 mb-1">Table 17</div>
							<div class="mb-3">Order No: #9046</div>
							<div class="mb-2">
								<span class="badge bg-gray-500 text-white fs-14px">Dine-in</span>
							</div>
							<div>All dish served<br>12:30 total time</div>
						</div>
						<div class="pos-task-body">
							<div class="fs-16px mb-3">
								Completed: (3/3)
							</div>
							<div class="row gx-4">
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-2.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Pork Burger</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- large size<br>
													- extra cheese<br>
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-10.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Mushroom soup</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte<br>
													- more cheese<br>
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-8.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Vita C Detox Juice</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- large size<br>
													- less ice<br>
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="pos-task">
						<div class="pos-task-info">
							<div class="h3 mb-1">Table 18</div>
							<div class="mb-3">Order No: #9043</div>
							<div class="mb-2">
								<span class="badge bg-gray-500 text-white fs-14px">Dine-in</span>
							</div>
							<div>All dish served<br>12:30 total time</div>
						</div>
						<div class="pos-task-body">
							<div class="fs-16px mb-3">
								Completed: (2/2)
							</div>
							<div class="row gx-4">
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-13.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Vanilla Ice Cream</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-9.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Pancake</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="pos-task">
						<div class="pos-task-info">
							<div class="h3 mb-1">Table 02</div>
							<div class="mb-3">Order No: #9045</div>
							<div class="mb-2">
								<span class="badge bg-gray-500 text-white fs-14px">Take Away</span>
							</div>
							<div>All dish served<br>22:28 total time</div>
						</div>
						<div class="pos-task-body">
							<div class="fs-16px mb-3">
								Completed: (3/3)
							</div>
							<div class="row gx-4">
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-4.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Vegan Salad Bowl&reg;</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-6.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Avocado Shake</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
								<div class="col-lg-3">
									<div class="pos-task-product completed">
										<div class="pos-task-product-img">
											<div class="cover" style="background-image: url(/assets/img/pos/product-5.jpg);"></div>
											<div class="caption">
												<div>Completed</div>
											</div>
										</div>
										<div class="pos-task-product-info">
											<div class="flex-1">
												<div class="d-flex mb-2">
													<div class="h5 mb-0 flex-1">Hawaiian Pizza&reg;</div>
													<div class="h5 mb-0">x1</div>
												</div>
												<div>
													- ala carte
												</div>
											</div>
										</div>
										<div class="pos-task-product-action">
											<a href="#" class="btn btn-success disabled">Complete</a>
											<a href="#" class="btn btn-outline-default disabled">Cancel</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- END pos-content -->
		</div>
		<!-- END pos-container -->

		<!-- BEGIN card-arrow -->
		<div class="card-arrow">
			<div class="card-arrow-top-left"></div>
			<div class="card-arrow-top-right"></div>
			<div class="card-arrow-bottom-left"></div>
			<div class="card-arrow-bottom-right"></div>
		</div>
		<!-- END card-arrow -->
	</div>
	<!-- END pos -->
@endsection
