@extends('layout.default')

@section('title', 'Dashboard')

@push('css')
    <link href="/assets/plugins/lity/dist/lity.min.css" rel="stylesheet">
    <link href="/assets/css/profile-dashboard.css" rel="stylesheet">
@endpush

@push('js')
    <script src="/assets/plugins/lity/dist/lity.min.js"></script>
    <script>
        // Real-time clock
        function updateClock() {
            const now = new Date();
            const timeString = now.toLocaleTimeString();
            document.getElementById('current-time').textContent = timeString;
        }
        setInterval(updateClock, 1000);
        updateClock();
    </script>
@endpush

@section('content')
    <div class="card">
        <div class="card-body p-0">
            <!-- BEGIN dashboard -->
            <div class="profile">
                <!-- BEGIN dashboard-container -->
                <div class="profile-container">
                    <!-- BEGIN dashboard-sidebar -->
                    @include('pages.system-dashboard.profile.sidebar')
                    <!-- END dashboard-sidebar -->

                    <!-- BEGIN dashboard-content -->
                    @include('pages.system-dashboard.profile.content')
                    <!-- END dashboard-content -->
                </div>
                <!-- END dashboard-container -->
            </div>
            <!-- END dashboard -->
        </div>
        <div class="card-arrow">
            <div class="card-arrow-top-left"></div>
            <div class="card-arrow-top-right"></div>
            <div class="card-arrow-bottom-left"></div>
            <div class="card-arrow-bottom-right"></div>
        </div>
    </div>
@endsection