@extends('layout.default')

@section('title', 'All Attendance Records')

{{-- هوية النيّون + التوستس زي بقية الصفحات --}}
@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        /* ====== Tokens (fallbacks فقط لو متغيّرات الثيم ناقصة) ====== */
        :root {

            /* --body-bg: var(--body-bg, #070b18); */


            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;


        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        /* ====== Headings ====== */
        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0 0 14px;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        /* ====== Shell / Cards ====== */
        .card-n {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            backdrop-filter: saturate(120%) blur(4px);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
        }

        .card-n .card-body {
            padding: 18px;
        }

        /* ====== KPI Cards ====== */
        .kpi {
            border-radius: 14px;
            padding: 18px;
            text-align: center;
            box-shadow: var(--glow);
        }

        .kpi .num {
            font-size: 28px;
            font-weight: 800;
            line-height: 1;
        }

        .kpi .lbl {
            font-size: 12px;
            opacity: .9;
            margin-top: 6px;
        }

        .kpi-success {
            background: linear-gradient(90deg, rgba(42, 252, 152, .25), rgba(0, 224, 255, .20));
            border: 1px solid rgba(42, 252, 152, .45);
        }

        .kpi-warning {
            background: linear-gradient(90deg, rgba(255, 185, 0, .27), rgba(255, 127, 39, .20));
            border: 1px solid rgba(255, 185, 0, .45);
        }

        .kpi-danger {
            background: linear-gradient(90deg, rgba(255, 95, 95, .26), rgba(255, 0, 130, .18));
            border: 1px solid rgba(255, 95, 95, .45);
        }

        .kpi-info {
            background: linear-gradient(90deg, rgba(0, 224, 255, .24), rgba(255, 95, 255, .18));
            border: 1px solid rgba(0, 224, 255, .45);
        }

        /* ====== Buttons ====== */
        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .5rem .9rem;
            border-radius: 10px;
            display: inline-flex;
            align-items: center;
            gap: .5rem;
            transition: transform .18s, box-shadow .18s, border-color .18s;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35);
        }

        /* ====== Table ====== */
        .tbl-wrap {
            border: 1px solid var(--border);
            border-radius: 12px;
            overflow: hidden;
        }

        table.table-neon {
            width: 100%;
            margin: 0;
            border-collapse: separate;
            border-spacing: 0;
            color: #dce7ff;
        }

        .table-neon thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            font-weight: 700;
            padding: 12px 14px;
            white-space: nowrap;
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        .table-neon tbody td {
            padding: 12px 14px;
            border-bottom: 1px solid rgba(0, 224, 255, .08);
            vertical-align: middle;
        }

        .table-neon tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* ====== Badges ====== */
        .badge-neon {
            display: inline-block;
            padding: .28rem .5rem;
            border-radius: 8px;
            font-weight: 700;
            font-size: .75rem;
            border: 1px solid transparent;
        }

        .bg-success-n {
            background: linear-gradient(90deg, rgba(42, 252, 152, .25), rgba(0, 224, 255, .18));
            color: #dfffea;
            border-color: rgba(42, 252, 152, .45);
        }

        .bg-info-n {
            background: linear-gradient(90deg, rgba(0, 224, 255, .25), rgba(255, 95, 255, .18));
            color: #e7fbff;
            border-color: rgba(0, 224, 255, .45);
        }

        .bg-warning-n {
            background: linear-gradient(90deg, rgba(255, 185, 0, .27), rgba(255, 127, 39, .20));
            color: #fff0c9;
            border-color: rgba(255, 185, 0, .45);
        }

        .muted {
            color: #8aa0c4;
        }

        /* ====== Pagination (Bootstrap) ====== */
        .pagination .page-link {
            /* background: #0e1326; */
            color: #cfe7ff;
            border: 1px solid var(--border);
        }

        .pagination .page-item.active .page-link {
            background: linear-gradient(90deg, rgba(0, 224, 255, .22), rgba(255, 95, 255, .18));
            border-color: var(--border-2);
            color: #fff;
            box-shadow: var(--glow);
        }

        /* ====== Modal ====== */
        .modal-content {
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .98), rgba(8, 12, 24, .98)); */
            color: #e8f1ff;
            border: 1px solid var(--border);
        }

        .modal-header {
            border-bottom-color: var(--border);
        }

        .modal-footer {
            border-top-color: var(--border);
        }

        .form-control {
            /* background: #0e1326; */
            color: #e8f1ff;
            border: 1px solid var(--border);
        }

        .form-control:focus {
            border-color: var(--border-2);
            box-shadow: var(--ring);
        }

        /* Util */
        .gap-12 {
            gap: 12px;
        }
    </style>
@endpush


@section('content')
    <div class="container-fluid py-3">

        {{-- Breadcrumb --}}


        {{-- Title --}}
        <h1 class="neon-title">All Attendance Records</h1>

        @if ($allAttendanceRecords->isEmpty())
            {{-- Empty state --}}
            <div class="card-n">
                <div class="card-body text-center py-5">
                    <i class="fa fa-calendar-times fa-3x muted mb-3"></i>
                    <h4 class="muted">No Attendance Records Found</h4>
                    <p class="muted mb-0">You don't have any attendance records yet.</p>
                </div>
            </div>
        @else
            {{-- KPI Row --}}
            <div class="row g-3 mb-4">
                <div class="col-md-3">
                    <div class="kpi kpi-success">
                        <div class="num">{{ $allAttendanceRecords->allTotals['total_present'] ?? 0 }}</div>
                        <div class="lbl">Present Days</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="kpi kpi-warning">
                        <div class="num">{{ $allAttendanceRecords->allTotals['total_late'] ?? 0 }}</div>
                        <div class="lbl">Late Arrivals</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="kpi kpi-danger">
                        <div class="num">{{ $allAttendanceRecords->allTotals['total_absent'] ?? 0 }}</div>
                        <div class="lbl">Absent Days</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="kpi kpi-info">
                        <div class="num">{{ $allAttendanceRecords->allTotals['total_records'] ?? 0 }}</div>
                        <div class="lbl">Total Records</div>
                    </div>
                </div>
            </div>

            {{-- Panel --}}
            <div class="card-n">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <h4 class="mb-0">{{ Auth::user()->name }}'s Complete Attendance History</h4>
                        <button class="neon-btn" id="customViewBtn" data-bs-toggle="modal"
                            data-bs-target="#customRangeModal">
                            <i class="fa fa-calendar"></i><span>Custom Range</span>
                        </button>
                    </div>

                    <div class="tbl-wrap">
                        <table class="table-neon">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Day</th>
                                    <th>Check-in</th>
                                    <th>Check-out</th>
                                    <th>Total Hours</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($allAttendanceRecords as $record)
                                    <tr>
                                        <td>{{ $record['formatted_date'] }}</td>
                                        <td>{{ $record['day_name'] }}</td>
                                        <td>
                                            @if ($record['check_in_time'])
                                                <span class="badge-neon bg-success-n">{{ $record['check_in_time'] }}</span>
                                            @else
                                                <span class="muted">--:--</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($record['check_out_time'])
                                                <span class="badge-neon bg-info-n">{{ $record['check_out_time'] }}</span>
                                            @else
                                                <span class="muted">--:--</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($record['total_hours'])
                                                <strong>{{ $record['total_hours'] }}</strong>
                                            @else
                                                <span class="muted">--</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{-- status_class جاي من السيرفر (Late/Present/Absent) --}}
                                            <span class="badge {{ $record['status_class'] }}">
                                                @switch($record['status'])
                                                    @case('present')
                                                        Present
                                                    @break

                                                    @case('late')
                                                        Late
                                                    @break

                                                    @case('absent')
                                                        Absent
                                                    @break

                                                    @case('in_progress')
                                                        In Progress
                                                    @break

                                                    @default
                                                        Unknown
                                                @endswitch
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    {{-- Pagination --}}
                    @if ($allAttendanceRecords->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            <nav aria-label="Attendance pagination">
                                <ul class="pagination pagination-lg">
                                    {{-- Prev --}}
                                    @if ($allAttendanceRecords->onFirstPage())
                                        <li class="page-item disabled"><span class="page-link">Previous</span></li>
                                    @else
                                        <li class="page-item"><a class="page-link"
                                                href="{{ $allAttendanceRecords->previousPageUrl() }}"
                                                rel="prev">Previous</a></li>
                                    @endif

                                    {{-- Numbers --}}
                                    @for ($page = 1; $page <= $allAttendanceRecords->lastPage(); $page++)
                                        @if ($page == $allAttendanceRecords->currentPage())
                                            <li class="page-item active"><span class="page-link">{{ $page }}</span>
                                            </li>
                                        @else
                                            <li class="page-item"><a class="page-link"
                                                    href="{{ $allAttendanceRecords->url($page) }}">{{ $page }}</a>
                                            </li>
                                        @endif
                                    @endfor

                                    {{-- Next --}}
                                    @if ($allAttendanceRecords->hasMorePages())
                                        <li class="page-item"><a class="page-link"
                                                href="{{ $allAttendanceRecords->nextPageUrl() }}" rel="next">Next</a>
                                        </li>
                                    @else
                                        <li class="page-item disabled"><span class="page-link">Next</span></li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    @endif
                </div>
            </div>
        @endif

        {{-- Modal --}}
        <div class="modal fade" id="customRangeModal" tabindex="-1" aria-labelledby="customRangeModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="customRangeModalLabel">
                            <i class="fa fa-calendar me-2"></i>Custom Date Range
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="GET" action="{{ route('profile.attendance.all') }}">
                        <div class="modal-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="start_date" class="form-label">Start Date</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date"
                                        value="{{ request('start_date') }}" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="end_date" class="form-label">End Date</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date"
                                        value="{{ request('end_date') }}" required>
                                </div>
                            </div>
                            <div class="mt-3">
                                <small class="sub-muted">
                                    <i class="fa fa-info-circle me-1"></i>
                                    Select a custom date range to filter attendance records
                                </small>
                            </div>
                        </div>
                        <div class="modal-footer gap-12">
                            <button type="button" class="neon-btn" data-bs-dismiss="modal">Cancel</button>
                            <a href="{{ route('profile.attendance.all') }}" class="neon-btn">Clear Filter</a>
                            <button type="submit" class="neon-btn">
                                <i class="fa fa-filter"></i><span>Apply Filter</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('js')
    <script>
        // Toast لطيف لما المستخدم يطبق الفلتر من المودال
        document.querySelector('#customRangeModal form')?.addEventListener('submit', function() {
            window.toast?.info('Filter Applied', 'Loading records…', 1200);
        });
    </script>
@endpush
