<div class="card mb-3 toolbar-card" style="background: rgba(255,255,255,.02); border:1px solid rgba(255,255,255,.06);">
  <div class="card-body py-2">
    <div class="row g-2 align-items-center">
      {{-- Has roles --}}
      <div class="col-12 col-sm-6 col-md-4 col-lg-2">
        <label for="filterHas" class="form-label form-label-compact">Scope</label>
        <select id="filterHas" class="form-select form-select-sm">
          <option value="all">All users</option>
          <option value="with">With roles</option>
          <option value="without">Without roles</option>
        </select>
      </div>

      {{-- Roles (multi) --}}
      <div class="col-12 col-sm-6 col-md-4 col-lg-4">
        <label for="filterRoles" class="form-label form-label-compact">Roles</label>
        <select id="filterRoles" class="form-select form-select-sm is-multi" multiple>
          @foreach($roles as $r)
            <option value="{{ $r->name }}">{{ $r->name }}</option>
          @endforeach
        </select>
      </div>

      {{-- Departments (multi) --}}
      <div class="col-12 col-md-4 col-lg-4">
        <label for="filterDepts" class="form-label form-label-compact">Departments</label>
        <select id="filterDepts" class="form-select form-select-sm is-multi" multiple>
          @foreach($departments as $d)
            <option value="{{ $d->id }}">{{ str_repeat('— ', (int)($d->depth ?? 0)) . $d->name }}</option>
          @endforeach
        </select>
      </div>

      {{-- Search + Reset --}}
      <div class="col-12 col-sm-8 col-md-6 col-lg-2 ms-lg-auto">
        <label for="globalSearch" class="form-label form-label-compact">Search</label>
        <div class="d-flex gap-2">
          <input id="globalSearch" class="form-control form-control-sm" placeholder="Search name or email">
          <button id="btnReset" class="btn btn-sm btn-neon btn-neon-outline flex-shrink-0">Reset</button>
        </div>
      </div>
    </div>
  </div>
</div>
