@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Add New Company</h2>
            <a href="/companies" class="btn btn-secondary">Back to List</a>
        </div>

        <!-- Success Message -->
        <div id="successMessage" class="alert alert-success" style="display: none;">
            Company added successfully!
        </div>

        <!-- Company Form -->
        <x-company-form />


    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            // Format salary input
            $('#salary').on('input', function() {
                let value = $(this).val().replace(/[^\d]/g, '');
                if (value) {
                    value = parseInt(value).toLocaleString();
                    $(this).val(value);
                }
            });


        });
    </script>
@endpush
