@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">
        <!-- Add New Company Button -->
        <div class="mb-3">
            <a class="btn btn-success" id="add-btn" href="{{ route('management.companies.create') }}">Add New Company</a>
        </div>

        <div id="datatableDefault_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
            @php
                $rows = [
                    ['name' => 'TechCorp', 'industry' => 'Technology', 'headquarters' => 'San Francisco', 'employees' => 5000, 'founded' => '2000-01-01'],
                    ['name' => 'HealthInc', 'industry' => 'Healthcare', 'headquarters' => 'New York', 'employees' => 3000, 'founded' => '1995-05-15'],
                    ['name' => 'AutoMakers', 'industry' => 'Automotive', 'headquarters' => 'Detroit', 'employees' => 10000, 'founded' => '1980-10-20'],
                ];
            @endphp

            <table id="datatableDefault" class="table text-nowrap w-100">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Company Name</th>
                    <th>Industry</th>
                    <th>Headquarters</th>
                    <th>Employees</th>
                    <th>Founded</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($rows as $i => $row)
                    <tr class="{{ $i % 2 === 0 ? 'odd' : 'even' }}">
                        <td class="dtr-control">{{ $i + 1 }}.</td>
                        <td>{{ $row['name'] }}</td>
                        <td>{{ $row['industry'] }}</td>
                        <td>{{ $row['headquarters'] }}</td>
                        <td>{{ $row['employees'] }}</td>
                        <td>{{ $row['founded'] }}</td>
                        <td></td> <!-- Actions rendered by DataTables -->
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this company?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger" id="confirm-delete">Delete</button>
                    </div>
                </div>
            </div>
        </div>



        <!-- Show Company Modal -->
        <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="showModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="showModalLabel">Company Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Company Name:</strong> <span id="show-name"></span></p>
                        <p><strong>Industry:</strong> <span id="show-industry"></span></p>
                        <p><strong>Headquarters:</strong> <span id="show-headquarters"></span></p>
                        <p><strong>Number of Employees:</strong> <span id="show-employees"></span></p>
                        <p><strong>Founded Date:</strong> <span id="show-founded"></span></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <link href="/assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <script src="/assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#datatableDefault').DataTable({
                dom: "<'row mb-3'<'col-sm-4'l><'col-sm-8 text-end'<'d-flex justify-content-end'fB>>>t<'d-flex align-items-center'<'me-auto'i><'mb-0'p>>",
                lengthMenu: [10, 20, 30, 40, 50],
                responsive: true,
                buttons: [
                    { extend: 'print', className: 'btn btn-default' },
                    { extend: 'csv', className: 'btn btn-default' }
                ],
                columnDefs: [
                    { targets: 0, orderable: false, searchable: false },
                    {
                        targets: 6,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return '<button class="btn btn-sm btn-danger delete-btn">Delete</button> ' +
                                '<a class="btn btn-sm btn-primary edit-btn" href="{{ route('management.companies.edit') }}">Edit</a> ' +
                                '<button class="btn btn-sm btn-info show-btn">Show</button>';
                        }
                    }
                ]
            });


            $(document).on('click', '.show-btn', function() {
                var row = table.row($(this).parents('tr'));
                var data = row.data();
                $('#show-name').text(data[1]);
                $('#show-industry').text(data[2]);
                $('#show-headquarters').text(data[3]);
                $('#show-employees').text(data[4]);
                $('#show-founded').text(data[5]);
                $('#showModal').modal('show');
            });

            // Delete Company
            $(document).on('click', '.delete-btn', function() {
                var row = table.row($(this).parents('tr'));
                $('#deleteModal').modal('show');
                $('#confirm-delete').data('row', row);
            });

            $('#confirm-delete').on('click', function() {
                var row = $(this).data('row');
                row.remove().draw();
                $('#deleteModal').modal('hide');
            });
        });
    </script>
@endpush
