@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">
        <!-- Add New Department Button -->
        <div class="mb-3">
            <a class="btn btn-success" id="add-btn" href="{{ route('management.departments.create') }}">Add New
                Department</a>
        </div>

        <div id="datatableDefault_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
            @php
                $rows = [
                    ['name' => 'Engineering', 'location' => 'New York', 'manager' => 'John Doe'],
                    ['name' => 'Marketing', 'location' => 'San Francisco', 'manager' => 'Jane Smith'],
                    ['name' => 'Sales', 'location' => 'Chicago', 'manager' => 'Alice Johnson'],
                ];
            @endphp

            <table id="datatableDefault" class="table text-nowrap w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Department Name</th>
                        <th>Location</th>
                        <th>Manager</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($rows as $i => $row)
                        <tr class="{{ $i % 2 === 0 ? 'odd' : 'even' }}">
                            <td class="dtr-control">{{ $i + 1 }}.</td>
                            <td>{{ $row['name'] }}</td>
                            <td>{{ $row['location'] }}</td>
                            <td>{{ $row['manager'] }}</td>
                            <td></td> <!-- Actions rendered by DataTables -->
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this department?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger" id="confirm-delete">Delete</button>
                    </div>
                </div>
            </div>
        </div>



        <!-- Show Department Modal -->
        <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="showModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="showModalLabel">Department Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Department Name:</strong> <span id="show-name"></span></p>
                        <p><strong>Location:</strong> <span id="show-location"></span></p>
                        <p><strong>Manager:</strong> <span id="show-manager"></span></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <link href="/assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <script src="/assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#datatableDefault').DataTable({
                dom: "<'row mb-3'<'col-sm-4'l><'col-sm-8 text-end'<'d-flex justify-content-end'fB>>>t<'d-flex align-items-center'<'me-auto'i><'mb-0'p>>",
                lengthMenu: [10, 20, 30, 40, 50],
                responsive: true,
                buttons: [{
                        extend: 'print',
                        className: 'btn btn-default'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-default'
                    }
                ],
                columnDefs: [{
                        targets: 0,
                        orderable: false,
                        searchable: false
                    },
                    {
                        targets: 4,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return '<button class="btn btn-sm btn-danger delete-btn">Delete</button> ' +
                                '<a class="btn btn-sm btn-primary edit-btn" href="{{ route('management.departments.edit') }}">Edit</a> ' +
                                '<button class="btn btn-sm btn-info show-btn">Show</button>';
                        }
                    }
                ]
            });

            // Add Department
            $('#add-btn').on('click', function() {
                $('#departmentForm')[0].reset();
                $('#departmentModalLabel').text('Add New Department');
                $('#save-department').data('action', 'add');
                $('#departmentModal').modal('show');
            });

            // Save Department (Add or Edit)
            $('#save-department').on('click', function() {
                var action = $(this).data('action');
                if (action === 'add') {
                    var newIndex = table.rows().count() + 1;
                    table.row.add([
                        newIndex,
                        $('#name').val(),
                        $('#location').val(),
                        $('#manager').val()
                    ]).draw();
                } else if (action === 'edit') {
                    var row = $(this).data('row');
                    var updatedData = [
                        row.data()[0], // Keep the index
                        $('#name').val(),
                        $('#location').val(),
                        $('#manager').val()
                    ];
                    row.data(updatedData).draw();
                }
                $('#departmentModal').modal('hide');
            });

            // Edit Department
            $(document).on('click', '.edit-btn', function() {
                var row = table.row($(this).parents('tr'));
                var data = row.data();
                $('#name').val(data[1]);
                $('#location').val(data[2]);
                $('#manager').val(data[3]);
                $('#departmentModalLabel').text('Edit Department');
                // $('#save-department').data('action', 'edit');
                $('#save-department').data('row', row);
                $('#departmentModal').modal('show');
            });

            // Show Department
            $(document).on('click', '.show-btn', function() {
                var row = table.row($(this).parents('tr'));
                var data = row.data();
                $('#show-name').text(data[1]);
                $('#show-location').text(data[2]);
                $('#show-manager').text(data[3]);
                $('#showModal').modal('show');
            });

            // Delete Department
            $(document).on('click', '.delete-btn', function() {
                var row = table.row($(this).parents('tr'));
                $('#deleteModal').modal('show');
                $('#confirm-delete').data('row', row);
            });

            $('#confirm-delete').on('click', function() {
                var row = $(this).data('row');
                row.remove().draw();
                $('#deleteModal').modal('hide');
            });
        });
    </script>
@endpush
