@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Edit Employee</h2>
            <a href="/employees" class="btn btn-secondary">Back to List</a>
        </div>

        <!-- Success Message -->
        <div id="successMessage" class="alert alert-success" style="display: none;">
            Employee Edited successfully!
        </div>

        <!-- Employee Form -->
        <x-employee-form />

    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            // Format salary input
            $('#salary').on('input', function() {
                let value = $(this).val().replace(/[^\d]/g, '');
                if (value) {
                    value = parseInt(value).toLocaleString();
                    $(this).val(value);
                }
            });

            // Form submission
            $('#employeeForm').on('submit', function(e) {
                e.preventDefault();

                let isValid = true;

                // Clear previous validation classes
                $('.form-control').removeClass('is-invalid');
                $('.invalid-feedback').text('');

                // Validate required fields
                $(this).find('[required]').each(function() {
                    if (!$(this).val().trim()) {
                        $(this).addClass('is-invalid');
                        $(this).siblings('.invalid-feedback').text('This field is required.');
                        isValid = false;
                    }
                });

                // Validate age
                let age = parseInt($('#age').val());
                if (age && (age < 18 || age > 100)) {
                    $('#age').addClass('is-invalid');
                    $('#age').siblings('.invalid-feedback').text('Age must be between 18 and 100.');
                    isValid = false;
                }
                //
                // if (isValid) {
                //     // Get existing employees from localStorage
                //     let employees = JSON.parse(localStorage.getItem('employees')) || [];
                //
                //     // Create new employee object
                //     const newEmployee = {
                //         id: employees.length > 0 ? Math.max(...employees.map(emp => emp.id)) + 1 : 1,
                //         name: $('#name').val(),
                //         position: $('#position').val(),
                //         office: $('#office').val(),
                //         age: parseInt($('#age').val()),
                //         start_date: $('#start_date').val(),
                //         salary: '$' + $('#salary').val()
                //     };
                //
                //     // Add to employees array
                //     employees.push(newEmployee);
                //
                //     // Save to localStorage
                //     localStorage.setItem('employees', JSON.stringify(employees));
                //
                //     // Show success message
                //     $('#successMessage').show();
                //
                //     // Reset form
                //     $('#employeeForm')[0].reset();
                //
                //     // Hide success message after 3 seconds
                //     setTimeout(function() {
                //         $('#successMessage').hide();
                //     }, 3000);
                //
                //     // Optionally redirect back to list
                //     setTimeout(function() {
                //         window.location.href = '/employees';
                //     }, 2000);
                //
                // } else {
                //     // Scroll to first error
                //     $('html, body').animate({
                //         scrollTop: $('.is-invalid').first().offset().top - 100
                //     }, 300);
                // }
            });
        });
    </script>
@endpush
