@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">

        <!-- Add New Employee Button -->
        <div class="mb-3">
            <a href="{{ route('management.employees.create') }}" class="btn btn-success">Add New Employee</a>
        </div>

        <div id="datatableDefault_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
            @php
                $rows = [
                    ['name' => 'Tiger Nixon', 'position' => 'System Architect', 'office' => 'Edinburgh', 'age' => 61, 'start_date' => '2011/04/25', 'salary' => '$320,800'],
                    ['name' => 'Garrett Winters', 'position' => 'Accountant', 'office' => 'Tokyo', 'age' => 63, 'start_date' => '2011/07/25', 'salary' => '$170,750'],
                    ['name' => 'Ashton Cox', 'position' => 'Junior Technical Author', 'office' => 'San Francisco', 'age' => 66, 'start_date' => '2009/01/12', 'salary' => '$86,000'],
                    ['name' => 'Cedric Kelly', 'position' => 'Senior Javascript Developer', 'office' => 'Edinburgh', 'age' => 22, 'start_date' => '2012/03/29', 'salary' => '$433,060'],
                    ['name' => 'Airi Satou', 'position' => 'Accountant', 'office' => 'Tokyo', 'age' => 33, 'start_date' => '2008/11/28', 'salary' => '$162,700'],
                    ['name' => 'Brielle Williamson', 'position' => 'Integration Specialist', 'office' => 'New York', 'age' => 61, 'start_date' => '2012/12/02', 'salary' => '$372,000'],
                    ['name' => 'Herrod Chandler', 'position' => 'Sales Assistant', 'office' => 'San Francisco', 'age' => 59, 'start_date' => '2012/08/06', 'salary' => '$137,500'],
                    ['name' => 'Rhona Davidson', 'position' => 'Integration Specialist', 'office' => 'Tokyo', 'age' => 55, 'start_date' => '2010/10/14', 'salary' => '$327,900'],
                    ['name' => 'Colleen Hurst', 'position' => 'Javascript Developer', 'office' => 'San Francisco', 'age' => 39, 'start_date' => '2009/09/15', 'salary' => '$205,500'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                    ['name' => 'Sonya Frost', 'position' => 'Software Engineer', 'office' => 'Edinburgh', 'age' => 23, 'start_date' => '2008/12/13', 'salary' => '$103,600'],
                ];
            @endphp

            <table id="datatableDefault" class="table text-nowrap w-100">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Position</th>
                    <th>Office</th>
                    <th>Age</th>
                    <th>Start Date</th>
                    <th style="display:none;">Salary</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($rows as $i => $row)
                    <tr class="{{ $i % 2 === 0 ? 'odd' : 'even' }}">
                        <td class="dtr-control">{{ $i + 1 }}.</td>
                        <td>{{ $row['name'] }}</td>
                        <td>{{ $row['position'] }}</td>
                        <td>{{ $row['office'] }}</td>
                        <td>{{ $row['age'] }}</td>
                        <td>{{ $row['start_date'] }}</td>
                        <td class="dtr-hidden" style="display:none;">{{ $row['salary'] }}</td>
                        <td></td> <!-- Actions rendered by DataTables -->
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this employee?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger" id="confirm-delete">Delete</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Show Employee Modal -->
        <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="showModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="showModalLabel">Employee Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Name:</strong> <span id="show-name"></span></p>
                        <p><strong>Position:</strong> <span id="show-position"></span></p>
                        <p><strong>Office:</strong> <span id="show-office"></span></p>
                        <p><strong>Age:</strong> <span id="show-age"></span></p>
                        <p><strong>Start Date:</strong> <span id="show-start_date"></span></p>
                        <p><strong>Salary:</strong> <span id="show-salary"></span></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <link href="/assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <script src="/assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#datatableDefault').DataTable({
                dom: "<'row mb-3'<'col-sm-4'l><'col-sm-8 text-end'<'d-flex justify-content-end'fB>>>t<'d-flex align-items-center'<'me-auto'i><'mb-0'p>>",
                lengthMenu: [10, 20, 30, 40, 50],
                responsive: true,
                buttons: [
                    { extend: 'print', className: 'btn btn-default' },
                    { extend: 'csv', className: 'btn btn-default' }
                ],
                columnDefs: [
                    { targets: 0, orderable: false, searchable: false },
                    { targets: 6, visible: false },
                    {
                        targets: 7,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return '<button class="btn btn-sm btn-danger delete-btn">Delete</button> ' +
                                '<a class="btn btn-sm btn-primary edit-btn" href="{{ route('management.employees.edit') }}">Edit</a> ' +
                                '<button class="btn btn-sm btn-info show-btn">Show</button>';
                        }
                    }
                ]
            });


            // Save Employee (Add or Edit)
            // $('#save-employee').on('click', function() {
            //     var action = $(this).data('action');
            //     if (action === 'add') {
            //         var newIndex = table.rows().count() + 1;
            //         table.row.add([
            //             newIndex,
            //             $('#name').val(),
            //             $('#position').val(),
            //             $('#office').val(),
            //             $('#age').val(),
            //             $('#start_date').val(),
            //             $('#salary').val()
            //         ]).draw();
            //     } else if (action === 'edit') {
            //         var row = $(this).data('row');
            //         var updatedData = [
            //             row.data()[0], // Keep the index
            //             $('#name').val(),
            //             $('#position').val(),
            //             $('#office').val(),
            //             $('#age').val(),
            //             $('#start_date').val(),
            //             $('#salary').val()
            //         ];
            //         row.data(updatedData).draw();
            //     }
            //     $('#employeeModal').modal('hide');
            // });



            // Show Employee
            $(document).on('click', '.show-btn', function() {
                var row = table.row($(this).parents('tr'));
                var data = row.data();
                $('#show-name').text(data[1]);
                $('#show-position').text(data[2]);
                $('#show-office').text(data[3]);
                $('#show-age').text(data[4]);
                $('#show-start_date').text(data[5]);
                $('#show-salary').text(data[6]);
                $('#showModal').modal('show');
            });

            // Delete Employee
            $(document).on('click', '.delete-btn', function() {
                var row = table.row($(this).parents('tr'));
                $('#deleteModal').modal('show');
                $('#confirm-delete').data('row', row);
            });

            $('#confirm-delete').on('click', function() {
                var row = $(this).data('row');
                row.remove().draw();
                $('#deleteModal').modal('hide');
            });
        });
    </script>
@endpush
