@extends('layout.default', [
    'appClass' => 'app-content-full-height',
])

@section('content')
    <div class="container">
        <!-- Add New Team Leader Button -->
        <div class="mb-3">
            <a class="btn btn-success" id="add-btn" href="{{ route('management.team-leaders.create') }}">Add New Team Leader</a>
        </div>

        <div id="datatableDefault_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
            @php
                $rows = [
                    ['name' => 'John Doe', 'department' => 'Engineering', 'team_members' => 10, 'start_date' => '2020-01-01'],
                    ['name' => 'Jane Smith', 'department' => 'Marketing', 'team_members' => 5, 'start_date' => '2019-05-15'],
                    ['name' => 'Alice Johnson', 'department' => 'Sales', 'team_members' => 8, 'start_date' => '2021-03-20'],
                ];
            @endphp

            <table id="datatableDefault" class="table text-nowrap w-100">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Department</th>
                    <th>Team Members</th>
                    <th>Start Date</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($rows as $i => $row)
                    <tr class="{{ $i % 2 === 0 ? 'odd' : 'even' }}">
                        <td class="dtr-control">{{ $i + 1 }}.</td>
                        <td>{{ $row['name'] }}</td>
                        <td>{{ $row['department'] }}</td>
                        <td>{{ $row['team_members'] }}</td>
                        <td>{{ $row['start_date'] }}</td>
                        <td></td> <!-- Actions rendered by DataTables -->
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this team leader?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger" id="confirm-delete">Delete</button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Show Team Leader Modal -->
        <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="showModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="showModalLabel">Team Leader Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Name:</strong> <span id="show-name"></span></p>
                        <p><strong>Department:</strong> <span id="show-department"></span></p>
                        <p><strong>Team Members:</strong> <span id="show-team_members"></span></p>
                        <p><strong>Start Date:</strong> <span id="show-start_date"></span></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <link href="/assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <script src="/assets/plugins/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            var table = $('#datatableDefault').DataTable({
                dom: "<'row mb-3'<'col-sm-4'l><'col-sm-8 text-end'<'d-flex justify-content-end'fB>>>t<'d-flex align-items-center'<'me-auto'i><'mb-0'p>>",
                lengthMenu: [10, 20, 30, 40, 50],
                responsive: true,
                buttons: [
                    { extend: 'print', className: 'btn btn-default' },
                    { extend: 'csv', className: 'btn btn-default' }
                ],
                columnDefs: [
                    { targets: 0, orderable: false, searchable: false },
                    {
                        targets: 5,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return '<button class="btn btn-sm btn-danger delete-btn">Delete</button> ' +
                                '<a class="btn btn-sm btn-primary edit-btn" href="{{ route('management.team-leaders.edit') }}">Edit</a> ' +
                                '<button class="btn btn-sm btn-info show-btn">Show</button>';
                        }
                    }
                ]
            });



            // Show Team Leader
            $(document).on('click', '.show-btn', function() {
                var row = table.row($(this).parents('tr'));
                var data = row.data();
                $('#show-name').text(data[1]);
                $('#show-department').text(data[2]);
                $('#show-team_members').text(data[3]);
                $('#show-start_date').text(data[4]);
                $('#showModal').modal('show');
            });

            // Delete Team Leader
            $(document).on('click', '.delete-btn', function() {
                var row = table.row($(this).parents('tr'));
                $('#deleteModal').modal('show');
                $('#confirm-delete').data('row', row);
            });

            $('#confirm-delete').on('click', function() {
                var row = $(this).data('row');
                row.remove().draw();
                $('#deleteModal').modal('hide');
            });
        });
    </script>
@endpush
