<!-- Recent Dynamic Attendance Records -->
<div class="card mb-3">
    <div class="card-header fw-bold bg-transparent d-flex justify-content-between align-items-center">
        <span>Recent Attendance Records</span>
        <a href="{{ route('profile.attendance.all') }}" class="btn btn-sm btn-outline-primary">
            <i class="fa fa-eye me-1"></i>View All Attendance
        </a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                <tr>
                    <th>Date</th>
                    <th>Check-in</th>
                    <th>Check-out</th>
                    <th>Hours</th>
                    <th>Status</th>
                </tr>
                </thead>
                <tbody>
                @forelse($recentAttendanceRecords as $record)
                    <tr>
                        <td>{{ $record['formatted_date'] }}</td>
                        <td>{{ $record['check_in_time'] ?? '--:--' }}</td>
                        <td>{{ $record['check_out_time'] ?? '--:--' }}</td>
                        <td>{{ $record['total_hours'] ?? '--' }}</td>
                        <td>
                                <span class="badge {{ $record['status_class'] }}">
                                    @switch($record['status'])
                                        @case('present')
                                            Present
                                            @break
                                        @case('late')
                                            Late
                                            @break
                                        @case('absent')
                                            Absent
                                            @break
                                        @case('in_progress')
                                            In Progress
                                            @break
                                        @default
                                            Unknown
                                    @endswitch
                                </span>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted py-4">
                            No attendance records found
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-arrow">
        <div class="card-arrow-top-left"></div>
        <div class="card-arrow-top-right"></div>
        <div class="card-arrow-bottom-left"></div>
        <div class="card-arrow-bottom-right"></div>
    </div>
</div>
