<!-- My Department Info -->
<div class="card mb-3">
  <div class="card-header fw-bold bg-transparent">
    <span>My Department Information</span>
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-6 mb-3">
        <div class="card department-card">
          <div class="card-body">
            <h6 class="fw-bold mb-2">
              {{ Auth::user()->department->name ?? 'Human Resources' }}
            </h6>
            <p class="text-muted mb-3">
              {{ Auth::user()->department->description ?? 'Responsible for employee relations, recruitment, and organizational development.' }}
            </p>

            <div class="mb-3">
              <small class="text-muted">Department Head:</small>
              <div class="d-flex align-items-center mt-1">
                <img src="/assets/img/user/user-1.jpg" alt="" width="30" class="rounded-circle me-2">
                <div>
                  <div class="fw-bold fs-13px">
                    {{ Auth::user()->department->head->name ?? 'Sarah Johnson' }}
                  </div>
                  <div class="fs-11px text-muted">
                    {{ Auth::user()->department->head->position ?? 'HR Director' }}
                  </div>
                </div>
              </div>
            </div>

            <div class="row text-center">
              <div class="col-6">
                <div class="fw-bold">
                  {{ Auth::user()->department->members_count ?? 8 }}
                </div>
                <small class="text-muted">Team Members</small>
              </div>
              <div class="col-6">
                <div class="fw-bold">
                  {{ Auth::user()->department->office_location ?? 'Floor 3' }}
                </div>
                <small class="text-muted">Office
                  Location</small>
              </div>
            </div>
          </div>
          <div class="card-arrow">
            <div class="card-arrow-top-left"></div>
            <div class="card-arrow-top-right"></div>
            <div class="card-arrow-bottom-left"></div>
            <div class="card-arrow-bottom-right"></div>
          </div>
        </div>
      </div>
      <div class="col-md-6 mb-3">
        <div class="card department-card">
          <div class="card-body">
            <h6 class="fw-bold mb-3">My Role & Position</h6>

            <div class="mb-3">
              <small class="text-muted">Position:</small>
              <div class="fw-bold">
                {{ Auth::user()->position ?? 'HR Specialist' }}
              </div>
            </div>

            <div class="mb-3">
              <small class="text-muted">Employee ID:</small>
              <div class="fw-bold">
                {{ Auth::user()->employee_id ?? 'EMP001' }}
              </div>
            </div>

            <div class="mb-3">
              <small class="text-muted">Join Date:</small>
              <div class="fw-bold">
                {{ Auth::user()->join_date ? date('F d, Y', strtotime(Auth::user()->join_date)) : 'January 15, 2023' }}
              </div>
            </div>

            <div class="mb-3">
              <small class="text-muted">Reporting To:</small>
              <div class="d-flex align-items-center mt-1">
                <img src="/assets/img/user/user-1.jpg" alt="" width="25" class="rounded-circle me-2">
                <div>
                  <div class="fw-bold fs-13px">
                    {{ Auth::user()->manager->name ?? 'Sarah Johnson' }}
                  </div>
                  <div class="fs-11px text-muted">
                    {{ Auth::user()->manager->position ?? 'HR Director' }}
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card-arrow">
            <div class="card-arrow-top-left"></div>
            <div class="card-arrow-top-right"></div>
            <div class="card-arrow-bottom-left"></div>
            <div class="card-arrow-bottom-right"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>