<ul class="profile-tab nav nav-tabs nav-tabs-v2"
    @if(config('profile_tabs.display.max_tabs')) data-max-tabs="{{ config('profile_tabs.display.max_tabs') }}" @endif>
  @if(isset($navigationTabs) && count($navigationTabs) > 0)
    @foreach($navigationTabs as $tab)
      <li class="nav-item {{ $tab['css_class'] ?? '' }}"
          @if(isset($tab['data_attributes']))
            @foreach($tab['data_attributes'] as $attr => $value) data-{{ $attr }}="{{ $value }}" @endforeach
          @endif>
        <a href="{{ $tab['url'] ?? '#' . $tab['id'] }}"
           class="nav-link {{ $tab['active'] ? 'active' : '' }} {{ $tab['link_class'] ?? '' }}"
           data-bs-toggle="tab"
           @if(isset($tab['tooltip'])) title="{{ $tab['tooltip'] }}" @endif
           @if(isset($tab['ajax_url'])) data-ajax-url="{{ $tab['ajax_url'] }}" @endif>
          @if(config('profile_tabs.display.show_icons', true) && isset($tab['icon']))
            <i class="{{ $tab['icon'] }} me-2"></i>
          @endif
          <div class="nav-field">
            {{ $tab['label'] }}
            @if(isset($tab['badge']) && $tab['badge']['show'])
              <span class="badge {{ $tab['badge']['class'] ?? 'bg-primary' }} ms-1">
                {{ $tab['badge']['value'] }}
              </span>
            @endif
          </div>
          @if(config('profile_tabs.display.show_values', true))
            <div class="nav-value {{ $tab['value_class'] ?? '' }}">
              {{ $tab['value'] }}
              @if(isset($tab['trend']))
                <i class="fas fa-arrow-{{ $tab['trend'] === 'up' ? 'up text-success' : 'down text-danger' }} ms-1"></i>
              @endif
            </div>
          @endif
        </a>
      </li>
    @endforeach
  @else
    {{-- Enhanced fallback with configuration --}}
    @php
      $fallbackTabs = [
        [
          'id' => 'profile-attendance',
          'label' => 'My Attendance',
          'value' => isset($attendanceStats['attendance_rate']) ? $attendanceStats['attendance_rate'] . '%' : '0%',
          'active' => true,
          'icon' => 'fas fa-clock'
        ],
        [
          'id' => 'profile-performance',
          'label' => 'My Performance',
          'value' => $performanceGrade ?? 'A+',
          'active' => false,
          'icon' => 'fas fa-chart-line'
        ]
      ];
    @endphp

    @foreach($fallbackTabs as $tab)
      <li class="nav-item">
        <a href="#{{ $tab['id'] }}" class="nav-link {{ $tab['active'] ? 'active' : '' }}" data-bs-toggle="tab">
          @if(config('profile_tabs.display.show_icons', true) && isset($tab['icon']))
            <i class="{{ $tab['icon'] }} me-2"></i>
          @endif
          <div class="nav-field">{{ $tab['label'] }}</div>
          @if(config('profile_tabs.display.show_values', true))
            <div class="nav-value">{{ $tab['value'] }}</div>
          @endif
        </a>
      </li>
    @endforeach
  @endif
</ul>
