<!-- My Performance Overview -->
<div class="card mb-3">
    <div class="card-header fw-bold bg-transparent d-flex justify-content-between align-items-center">
        <span>My Performance Summary</span>
        <div class="d-flex gap-2">
            <button class="btn btn-sm btn-outline-primary" id="weekViewBtn" data-period="week">Week</button>
            <button class="btn btn-sm btn-outline-primary" id="monthViewBtn" data-period="month">Month</button>
            <button class="btn btn-sm btn-outline-secondary" id="customViewBtn" data-bs-toggle="modal" data-bs-target="#customRangeModal">Custom</button>
        </div>
    </div>
    <div class="card-body">

        <!-- Performance Summary Cards -->
        <div class="row mb-4" id="performanceSummary">
            <div class="col-md-4 mb-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h4 class="mb-0" id="attendanceRate">--</h4>
                        <small>Attendance Rate</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h4 class="mb-0" id="totalHours">--</h4>
                        <small>Total Hours</small>
                    </div>
                </div>
            </div>
{{--            <div class="col-md-3 mb-3">--}}
{{--                <div class="card bg-info text-white">--}}
{{--                    <div class="card-body text-center">--}}
{{--                        <h4 class="mb-0" id="avgHours">--</h4>--}}
{{--                        <small>Avg Hours/Day</small>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
            <div class="col-md-4 mb-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h4 class="mb-0" id="presentDays">--</h4>
                        <small>Present Days</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row">
            <!-- Attendance Chart -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">Daily Attendance Status</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="attendanceChart" width="400" height="300"></canvas>
                    </div>
                </div>
            </div>

            <!-- Hours Worked Chart -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">Hours Worked Per Day</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="hoursChart" width="400" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status Breakdown -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">Status Breakdown</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="statusPieChart" width="400" height="300"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">Performance Metrics</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Present Days:</span>
                            <span class="fw-bold text-success" id="detailPresentDays">--</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Late Days:</span>
                            <span class="fw-bold text-warning" id="detailLateDays">--</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Absent Days:</span>
                            <span class="fw-bold text-danger" id="detailAbsentDays">--</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Total Working Days:</span>
                            <span class="fw-bold" id="detailTotalDays">--</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <span>Period:</span>
                            <span class="fw-bold" id="currentPeriod">This Week</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="card-arrow">
        <div class="card-arrow-top-left"></div>
        <div class="card-arrow-top-right"></div>
        <div class="card-arrow-bottom-left"></div>
        <div class="card-arrow-bottom-right"></div>
    </div>
</div>

<!-- Custom Date Range Modal -->
<div class="modal fade" id="customRangeModal" tabindex="-1" aria-labelledby="customRangeModalLabel" aria-hidden="true" data-bs-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customRangeModalLabel">Select Custom Date Range</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="customRangeForm">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="startDate" class="form-label">Start Date</label>
                            <input type="date" class="form-control" id="startDate" required>
                        </div>
                        <div class="col-md-6">
                            <label for="endDate" class="form-label">End Date</label>
                            <input type="date" class="form-control" id="endDate" required>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="applyCustomRange">Apply Range</button>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js and Performance Analytics JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    class PerformanceAnalytics {
        constructor() {
            this.attendanceChart = null;
            this.hoursChart = null;
            this.statusPieChart = null;
            this.currentPeriod = 'week';
            this.weekData = @json($weekPerformance ?? []);
            this.monthData = @json($monthPerformance ?? []);

            this.init();
        }

        init() {
            this.setupEventListeners();
            this.loadInitialData();
        }

        setupEventListeners() {
            // Period buttons
            document.getElementById('weekViewBtn').addEventListener('click', () => this.switchPeriod('week'));
            document.getElementById('monthViewBtn').addEventListener('click', () => this.switchPeriod('month'));

            // Custom range modal
            document.getElementById('applyCustomRange').addEventListener('click', () => this.applyCustomRange());

            // Set initial active button
            this.setActiveButton('week');
        }

        loadInitialData() {
            if (this.weekData && Object.keys(this.weekData).length > 0) {
                this.updateCharts(this.weekData);
                this.updateSummary(this.weekData);
            }
        }

        switchPeriod(period) {
            this.currentPeriod = period;
            this.setActiveButton(period);

            if (period === 'week' && this.weekData) {
                this.updateCharts(this.weekData);
                this.updateSummary(this.weekData);
                document.getElementById('currentPeriod').textContent = 'This Week';
            } else if (period === 'month' && this.monthData) {
                this.updateCharts(this.monthData);
                this.updateSummary(this.monthData);
                document.getElementById('currentPeriod').textContent = 'This Month';
            } else {
                this.fetchPerformanceData(period);
            }
        }

        setActiveButton(period) {
            // Remove active class from all buttons
            document.querySelectorAll('[data-period]').forEach(btn => {
                btn.classList.remove('btn-primary');
                btn.classList.add('btn-outline-primary');
            });

            // Add active class to selected button
            const activeBtn = document.querySelector(`[data-period="${period}"]`);
            if (activeBtn) {
                activeBtn.classList.remove('btn-outline-primary');
                activeBtn.classList.add('btn-primary');
            }
        }

        async fetchPerformanceData(type, startDate = null, endDate = null) {
            try {
                const url = new URL('/profile/performance/data', window.location.origin);
                url.searchParams.append('type', type);
                if (startDate) url.searchParams.append('start_date', startDate);
                if (endDate) url.searchParams.append('end_date', endDate);

                const response = await fetch(url);
                const data = await response.json();

                this.updateCharts(data);
                this.updateSummary(data);

                if (type === 'custom') {
                    document.getElementById('currentPeriod').textContent = `${startDate} to ${endDate}`;
                }
            } catch (error) {
                console.error('Error fetching performance data:', error);
            }
        }

        updateCharts(data) {
            this.createAttendanceChart(data);
            this.createHoursChart(data);
            this.createStatusPieChart(data);
        }

        createAttendanceChart(data) {
            const ctx = document.getElementById('attendanceChart').getContext('2d');

            if (this.attendanceChart) {
                this.attendanceChart.destroy();
            }

            this.attendanceChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: data.labels,
                    datasets: [{
                        label: 'Attendance Status',
                        data: data.datasets.attendance,
                        backgroundColor: data.datasets.attendance.map(value => {
                            if (value === 1) return '#28a745'; // Present - Green
                            if (value === 0.5) return '#ffc107'; // Late - Yellow
                            return '#dc3545'; // Absent - Red
                        }),
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 1,
                            ticks: {
                                callback: function(value) {
                                    if (value === 1) return 'Present';
                                    if (value === 0.5) return 'Late';
                                    if (value === 0) return 'Absent';
                                    return '';
                                }
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const value = context.parsed.y;
                                    if (value === 1) return 'Present';
                                    if (value === 0.5) return 'Late';
                                    return 'Absent';
                                }
                            }
                        }
                    }
                }
            });
        }

        createHoursChart(data) {
            const ctx = document.getElementById('hoursChart').getContext('2d');

            if (this.hoursChart) {
                this.hoursChart.destroy();
            }

            this.hoursChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: data.labels,
                    datasets: [{
                        label: 'Hours Worked',
                        data: data.datasets.hours_worked,
                        borderColor: '#007bff',
                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Hours'
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    }
                }
            });
        }

        createStatusPieChart(data) {
            const ctx = document.getElementById('statusPieChart').getContext('2d');

            if (this.statusPieChart) {
                this.statusPieChart.destroy();
            }

            this.statusPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['Present', 'Late', 'Absent'],
                    datasets: [{
                        data: [
                            data.status_breakdown.present,
                            data.status_breakdown.late,
                            data.status_breakdown.absent
                        ],
                        backgroundColor: ['#28a745', '#ffc107', '#dc3545'],
                        borderWidth: 2,
                        borderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });
        }

        updateSummary(data) {
            document.getElementById('attendanceRate').textContent = data.summary.attendance_rate + '%';
            document.getElementById('totalHours').textContent = data.summary.total_hours + 'h';
            document.getElementById('avgHours').textContent = data.summary.avg_hours_per_day + 'h';
            document.getElementById('presentDays').textContent = data.summary.present_days;

            // Update detailed metrics
            document.getElementById('detailPresentDays').textContent = data.summary.present_days;
            document.getElementById('detailLateDays').textContent = data.summary.late_days;
            document.getElementById('detailAbsentDays').textContent = data.summary.absent_days;
            document.getElementById('detailTotalDays').textContent = data.summary.total_working_days;
        }

        applyCustomRange() {
            const startDate = document.getElementById('startDate').value;
            const endDate = document.getElementById('endDate').value;

            if (!startDate || !endDate) {
                alert('Please select both start and end dates');
                return;
            }

            if (new Date(startDate) > new Date(endDate)) {
                alert('Start date must be before end date');
                return;
            }

            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('customRangeModal'));
            modal.hide();

            // Reset button states
            document.querySelectorAll('[data-period]').forEach(btn => {
                btn.classList.remove('btn-primary');
                btn.classList.add('btn-outline-primary');
            });

            // Fetch custom data
            this.fetchPerformanceData('custom', startDate, endDate);
        }
    }

    // Initialize when DOM is loaded
    document.addEventListener('DOMContentLoaded', function() {
        new PerformanceAnalytics();
    });
</script>

<style>
    .card canvas {
        max-height: 300px;
    }

    .btn-group .btn {
        border-radius: 0;
    }

    .btn-group .btn:first-child {
        border-top-left-radius: 0.375rem;
        border-bottom-left-radius: 0.375rem;
    }

    .btn-group .btn:last-child {
        border-top-right-radius: 0.375rem;
        border-bottom-right-radius: 0.375rem;
    }

    .modal {
        z-index: 1056 !important;
    }
</style>
