<!-- Team Attendance Overview -->
<div class="card">
  <div class="card-header fw-bold bg-transparent">Team Attendance Today</div>
  <div class="card-body">
    @if(isset($teamAttendance) && count($teamAttendance) > 0)
      <div class="row">
        @foreach($teamAttendance as $member)
          <div class="col-md-6 mb-3">
            <div class="d-flex align-items-center">
              @if($member['avatar'])
                <img src="{{ $member['avatar'] }}" alt="{{ $member['name'] }}" width="40" class="rounded-circle me-3">
              @else
                <div class="rounded-circle bg-secondary d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                  <span class="text-white">{{ substr($member['name'], 0, 1) }}</span>
                </div>
              @endif
              <div class="flex-fill">
                <div class="fw-bold">{{ $member['name'] }}</div>
                <div class="fs-12px text-inverse text-opacity-50">{{ $member['position'] ?? 'Employee' }}</div>
              </div>
              <div class="attendance-status {{ $member['status_class'] }}"></div>
              <small class="text-{{ $member['text_class'] }} ms-2">{{ $member['status_label'] }}</small>
            </div>
          </div>
        @endforeach
      </div>
    @else
      <div class="text-center py-4">
        <div class="text-muted">
          <i class="fas fa-users fa-3x mb-3"></i>
          <p>No team members found or you are not part of a team.</p>
        </div>
      </div>
    @endif
  </div>
  <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
  </div>
</div>