<!-- Today's Dynamic Attendance -->
<div class="card mb-3">
    <div class="card-header fw-bold bg-transparent">
        <span>Today's Attendance Status</span>
    </div>
    <div class="card-body">
        <div class="d-flex align-items-center mb-3">
            <div class="attendance-status {{ $todayAttendance['has_checked_in'] ? 'present' : 'absent' }}"></div>
            <strong>Check-in:
                @if($todayAttendance['has_checked_in'])
                    {{ $todayAttendance['check_in_time'] }}
                @else
                    --:-- --
                @endif
            </strong>
            <span class="ms-auto
        @if($todayAttendance['check_in_status'] === 'on_time') text-success
        @elseif($todayAttendance['check_in_status'] === 'late') text-warning
        @else text-muted
        @endif">
        @if($todayAttendance['check_in_status'] === 'on_time')
                    On Time
                @elseif($todayAttendance['check_in_status'] === 'late')
                    Late
                @else
                    Not Checked In
                @endif
      </span>
        </div>
        <div class="d-flex align-items-center">
            <div class="attendance-status {{ $todayAttendance['has_checked_out'] ? 'present' : 'absent' }}"></div>
            <strong>Check-out:
                @if($todayAttendance['has_checked_out'])
                    {{ $todayAttendance['check_out_time'] }}
                @else
                    --:-- --
                @endif
            </strong>
            <span class="ms-auto
        @if($todayAttendance['check_out_status'] === 'completed') text-success
        @else text-muted
        @endif">
        @if($todayAttendance['check_out_status'] === 'completed')
                    Completed
                @else
                    Pending
                @endif
      </span>
        </div>

        @if($todayAttendance['total_hours'])
            <div class="d-flex align-items-center mt-2">
                <div class="attendance-status present"></div>
                <strong>Total Hours: {{ $todayAttendance['total_hours'] }}</strong>
            </div>
        @endif
    </div>
    <div class="card-arrow">
        <div class="card-arrow-top-left"></div>
        <div class="card-arrow-top-right"></div>
        <div class="card-arrow-bottom-left"></div>
        <div class="card-arrow-bottom-right"></div>
    </div>
</div>
