<div class="profile-img position-relative">
  <img id="avatar-preview" src="{{ Auth::user()->avatar ? Storage::url(Auth::user()->avatar) : '/assets/img/ai/imagine-21.jpg' }}" alt="">
  <div class="avatar-edit-overlay">
    <label for="avatar-upload" class="avatar-edit-btn">
      <i class="fa fa-pen"></i>
    </label>
    <input type="file" id="avatar-upload" accept="image/*" style="display: none;">
  </div>
</div>
<!-- User profile info -->
<h4>{{ Auth::user()->name ?? 'John Smith' }}</h4>
<div class="mb-3 text-inverse text-opacity-50 fw-bold mt-n2">{{ Auth::user()->email ??
  'admin@company.com' }}</div>
<p>
  Title: {{ Auth::user()->title ?? 'employee' }}
    <br>
  Employee ID: {{ Auth::id() ?? 'EMP001' }}<br>
  <span class="badge bg-success">Active</span>
</p>
<div class="mb-1">
  <i class="fa fa-clock fa-fw text-inverse text-opacity-50"></i> <span id="current-time"></span>
</div>
<div class="mb-1">
  <i class="fa fa-calendar fa-fw text-inverse text-opacity-50"></i> {{ date('F d, Y') }}
</div>
<div class="mb-3">
  <i class="fa fa-map-marker-alt fa-fw text-inverse text-opacity-50"></i> Office Location
</div>

<style>
.profile-img {
  position: relative;
  display: inline-block;
}

.avatar-edit-overlay {
  position: absolute;
  bottom: 0;
  right: 0;
  background-color: rgba(0, 0, 0, 0.7);
  border-radius: 50%;
  width: 35px;
  height: 35px;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  transition: all 0.3s ease;
}

.avatar-edit-overlay:hover {
  background-color: rgba(0, 0, 0, 0.9);
  transform: scale(1.1);
}

.avatar-edit-btn {
  color: white;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  width: 100%;
  height: 100%;
}

.avatar-edit-btn i {
  font-size: 14px;
}

#avatar-preview {
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 5px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const avatarUpload = document.getElementById('avatar-upload');
    const avatarPreview = document.getElementById('avatar-preview');

    avatarUpload.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            const reader = new FileReader();

            reader.onload = function(e) {
                avatarPreview.src = e.target.result;
            };

            reader.readAsDataURL(file);

            // Upload the file
            const formData = new FormData();
            formData.append('avatar', file);
            formData.append('_token', '{{ csrf_token() }}');

            fetch('{{ route("profile.avatar.update") }}', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Show success message
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: data.message || 'Avatar updated successfully!',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    // Revert image on error
                    avatarPreview.src = data.old_avatar || '/assets/img/ai/imagine-21.jpg';
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: data.message || 'Failed to update avatar'
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'An error occurred while updating avatar'
                });
            });
        }
    });
});
</script>
